/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.normalize;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.search.normalize.VersionNormalizer;
import org.sonatype.nexus.repository.search.normalize.VersionNumberExpander;

@Named
@Singleton
public class VersionNormalizerService {
    private final Map<String, VersionNormalizer> versionNormalizers;

    @Inject
    public VersionNormalizerService(Map<String, VersionNormalizer> versionNormalizers) {
        this.versionNormalizers = (Map)Preconditions.checkNotNull(versionNormalizers);
    }

    public String getNormalizedVersionByFormat(String version, Format format) {
        VersionNormalizer normalizerForFormat = this.versionNormalizers.get(format.getValue());
        if (Objects.nonNull(normalizerForFormat)) {
            return normalizerForFormat.getNormalizedVersion(version);
        }
        return VersionNumberExpander.expand(version);
    }
}

