/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.index;

import javax.inject.Named;
import org.elasticsearch.ElasticsearchException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.search.index.SearchIndexFacet;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class RebuildIndexTask
extends RepositoryTaskSupport
implements Cancelable {
    protected void execute(Repository repository) {
        try {
            ((SearchIndexFacet)repository.facet(SearchIndexFacet.class)).rebuildIndex();
        }
        catch (ElasticsearchException e) {
            this.log.error("Could not perform rebuild index for repo {}, {}", (Object)repository.getName(), (Object)e.getMessage());
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.optionalFacet(SearchIndexFacet.class).isPresent();
    }

    public String getMessage() {
        return "Rebuilding search index of " + this.getRepositoryField();
    }
}

