/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;

class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static JsonNode readTree(String json) throws IOException {
        return MAPPER.readTree(json);
    }

    public static String from(Object value) throws IOException {
        return WRITER.writeValueAsString(value);
    }

    public static String merge(String ... jsons) throws IOException {
        ObjectNode merged = MAPPER.createObjectNode();
        String[] stringArray = jsons;
        int n = jsons.length;
        int n2 = 0;
        while (n2 < n) {
            String json = stringArray[n2];
            merged = JsonUtils.merge((JsonNode)merged, MAPPER.readTree(json));
            ++n2;
        }
        return WRITER.writeValueAsString((Object)merged);
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                JsonUtils.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mainNode).set(fieldName, value);
        }
        return mainNode;
    }
}

