/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.index;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.sonatype.goodies.common.ComponentSupport;

class BulkIndexUpdateListener
extends ComponentSupport
implements BulkProcessor.Listener {
    private final AtomicInteger inflightRequestCount = new AtomicInteger();

    BulkIndexUpdateListener() {
    }

    int inflightRequestCount() {
        return this.inflightRequestCount.get();
    }

    public void beforeBulk(long executionId, BulkRequest request) {
        this.inflightRequestCount.getAndAdd(request.numberOfActions());
        if (this.log.isDebugEnabled()) {
            this.log.debug("index update starting, executionId: {}, request count: {}, request size (bytes): {}", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes()});
        }
    }

    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
        this.inflightRequestCount.getAndAdd(-request.numberOfActions());
        if (this.log.isDebugEnabled()) {
            this.log.debug("index update success, executionId: {}, request count: {}, request size (bytes): {}; response took: {}, response hasFailures: {}", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), response.getTook(), response.hasFailures()});
        }
    }

    public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
        this.inflightRequestCount.getAndAdd(-request.numberOfActions());
        this.log.error("index update failure, executionId: {}, request count: {}, request size (bytes): {}; this may indicate that not enough CPU is available to effectively index repository content", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes(), failure});
    }
}

