/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.internal.resources.TokenEncoder;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.elasticsearch.OrientSearchExtension;
import org.sonatype.nexus.repository.search.index.ElasticSearchIndexService;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.ElasticSearchUtils;

@Named
@Singleton
public class ElasticSearchServiceImpl
extends ComponentSupport
implements SearchService {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSZ");
    private final ElasticSearchQueryService elasticSearchQueryService;
    private final ElasticSearchIndexService elasticSearchIndexService;
    private final ElasticSearchUtils elasticSearchUtils;
    private final TokenEncoder tokenEncoder;
    private final Set<OrientSearchExtension> decorators;

    @Inject
    public ElasticSearchServiceImpl(ElasticSearchQueryService elasticSearchQueryService, ElasticSearchIndexService elasticSearchIndexService, ElasticSearchUtils elasticSearchUtils, TokenEncoder tokenEncoder, Set<OrientSearchExtension> decorators) {
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
        this.elasticSearchIndexService = (ElasticSearchIndexService)Preconditions.checkNotNull((Object)elasticSearchIndexService);
        this.elasticSearchUtils = (ElasticSearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)elasticSearchUtils)));
        this.tokenEncoder = (TokenEncoder)((Object)Preconditions.checkNotNull((Object)((Object)tokenEncoder)));
        this.decorators = (Set)Preconditions.checkNotNull(decorators);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) {
        QueryBuilder queryBuilder = this.elasticSearchUtils.buildQuery(searchRequest);
        int from = Optional.ofNullable(searchRequest.getContinuationToken()).filter(Strings2::notBlank).map(__ -> this.decodeFrom(searchRequest, queryBuilder)).orElseGet(() -> Optional.ofNullable(searchRequest.getOffset()).orElse(0));
        org.elasticsearch.action.search.SearchResponse searchResponse = this.elasticSearchQueryService.search(queryBuilder, from, searchRequest.getLimit());
        return this.convertSearchResponse(searchResponse, this.continuationToken(searchRequest, queryBuilder, searchResponse));
    }

    @Override
    public Iterable<ComponentSearchResult> browse(SearchRequest searchRequest) {
        Iterable<SearchHit> browse = this.elasticSearchQueryService.browse(this.elasticSearchUtils.buildQuery(searchRequest));
        return () -> new SearchResultIterator(browse.iterator());
    }

    @Override
    public long count(SearchRequest searchRequest) {
        return this.elasticSearchQueryService.count(this.elasticSearchUtils.buildQuery(searchRequest));
    }

    @Override
    public void waitForCalm() {
        this.elasticSearchIndexService.waitForCalm();
    }

    private String continuationToken(SearchRequest request, QueryBuilder query, org.elasticsearch.action.search.SearchResponse searchResponse) {
        if (request.getLimit() != searchResponse.getHits().hits().length) {
            return null;
        }
        int from = this.decodeFrom(request, query);
        return this.tokenEncoder.encode(from, request.getLimit(), query);
    }

    private int decodeFrom(SearchRequest request, QueryBuilder query) {
        return this.tokenEncoder.decode(request.getContinuationToken(), query);
    }

    private SearchResponse convertSearchResponse(org.elasticsearch.action.search.SearchResponse esResponse, String continuationToken) {
        SearchResponse searchResponse = new SearchResponse();
        ArrayList<ComponentSearchResult> componentSearchResults = new ArrayList<ComponentSearchResult>();
        for (SearchHit hit : esResponse.getHits()) {
            componentSearchResults.add(this.toComponentSearchResult(hit));
        }
        searchResponse.setSearchResults(componentSearchResults);
        searchResponse.setContinuationToken(continuationToken);
        searchResponse.setTotalHits(esResponse.getHits().getTotalHits());
        return searchResponse;
    }

    private ComponentSearchResult toComponentSearchResult(SearchHit componentHit) {
        Map componentMap = (Map)Preconditions.checkNotNull((Object)componentHit.getSource());
        Repository repository = this.elasticSearchUtils.getReadableRepository((String)componentMap.get("repository_name"));
        ComponentSearchResult componentSearchResult = new ComponentSearchResult();
        List assets = (List)componentMap.get("assets");
        if (assets != null) {
            componentSearchResult.setAssets(assets.stream().map(assetMap -> this.toAssetSearchResult((Map<String, Object>)assetMap, repository)).collect(Collectors.toList()));
        } else {
            componentSearchResult.setAssets((List<AssetSearchResult>)ImmutableList.of());
        }
        componentSearchResult.setGroup((String)componentMap.get("group"));
        componentSearchResult.setName((String)componentMap.get("name"));
        componentSearchResult.setVersion((String)componentMap.get("version"));
        componentSearchResult.setId(componentHit.getId());
        componentSearchResult.setRepositoryName(repository.getName());
        componentSearchResult.setFormat(repository.getFormat().getValue());
        componentSearchResult.setLastDownloaded(this.calculateOffsetDateTime(componentMap, "lastDownloaded"));
        componentSearchResult.setLastModified(this.calculateOffsetDateTime(componentMap, "lastBlobUpdated"));
        this.decorators.forEach(extension -> extension.updateComponent(componentSearchResult, componentHit));
        return componentSearchResult;
    }

    private AssetSearchResult toAssetSearchResult(Map<String, Object> assetMap, Repository repository) {
        AssetSearchResult assetSearchResult = new AssetSearchResult();
        assetSearchResult.setAttributes(assetMap.getOrDefault("attributes", Collections.emptyMap()));
        assetSearchResult.setPath((String)assetMap.get("name"));
        assetSearchResult.setRepository(repository.getName());
        assetSearchResult.setId(String.valueOf(assetMap.get("id")));
        assetSearchResult.setChecksum((Map)assetSearchResult.getAttributes().get("checksum"));
        assetSearchResult.setFormat(repository.getFormat().getValue());
        assetSearchResult.setContentType((String)assetMap.get("content_type"));
        assetSearchResult.setLastModified(this.calculateLastModified(assetSearchResult.getAttributes()));
        assetSearchResult.setUploader((String)assetMap.get("uploader"));
        assetSearchResult.setUploaderIp((String)assetMap.get("uploaderIp"));
        assetSearchResult.setLastDownloaded(this.calculateLastDownloaded(assetMap));
        assetSearchResult.setFileSize(this.getFileSize(assetMap));
        return assetSearchResult;
    }

    private Long getFileSize(Map<String, Object> attributes) {
        return Optional.ofNullable(attributes.get("fileSize")).map(Number.class::cast).map(Number::longValue).orElse(null);
    }

    private OffsetDateTime calculateOffsetDateTime(Map<String, Object> attributes, String field) {
        try {
            return Optional.ofNullable(attributes.get(field)).map(String.class::cast).map(DATE_TIME_FORMATTER::parse).map(Instant::from).map(instant -> OffsetDateTime.ofInstant(instant, ZoneOffset.UTC)).orElse(null);
        }
        catch (Exception ignored) {
            this.log.debug("Unable to retrieve {}", (Object)field, (Object)ignored);
            return null;
        }
    }

    private Date calculateLastDownloaded(Map<String, Object> attributes) {
        try {
            return Optional.ofNullable(attributes.get("lastDownloaded")).map(String.class::cast).map(DATE_TIME_FORMATTER::parse).map(Instant::from).map(Date::from).orElse(null);
        }
        catch (Exception ignored) {
            this.log.debug("Unable to retrieve last_downloaded", (Throwable)ignored);
            return null;
        }
    }

    private Date calculateLastModified(Map<String, Object> attributes) {
        try {
            return Optional.ofNullable(attributes.get("content")).map(Map.class::cast).map(content -> content.get("last_modified")).map(Object::toString).map(Long::parseLong).map(Date::new).orElse(null);
        }
        catch (Exception ignored) {
            this.log.debug("Unable to retrieve last_modified", (Throwable)ignored);
            return null;
        }
    }

    private class SearchResultIterator
    implements Iterator<ComponentSearchResult> {
        private final Iterator<SearchHit> searchHitIterator;

        public SearchResultIterator(Iterator<SearchHit> searchHitIterator) {
            this.searchHitIterator = searchHitIterator;
        }

        @Override
        public boolean hasNext() {
            return this.searchHitIterator.hasNext();
        }

        @Override
        public ComponentSearchResult next() {
            return ElasticSearchServiceImpl.this.toComponentSearchResult(this.searchHitIterator.next());
        }
    }
}

