/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.search.query.SearchFilter;

@Named
@Singleton
public class SearchUtils
extends ComponentSupport {
    public static final String CONTINUATION_TOKEN = "continuationToken";
    public static final String SORT_FIELD = "sort";
    public static final String SORT_DIRECTION = "direction";
    private static final String ASSET_PREFIX = "assets.";
    private final RepositoryManagerRESTAdapter repoAdapter;
    private final Map<String, String> searchParams;
    private final Map<String, String> assetSearchParams;

    @Inject
    public SearchUtils(RepositoryManagerRESTAdapter repoAdapter, Map<String, SearchMappings> searchMappings) {
        this.repoAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repoAdapter);
        this.searchParams = ((Map)Preconditions.checkNotNull(searchMappings)).entrySet().stream().flatMap(e -> StreamSupport.stream(((SearchMappings)e.getValue()).get().spliterator(), true)).collect(Collectors.toMap(SearchMapping::getAlias, SearchMapping::getAttribute));
        this.assetSearchParams = this.searchParams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith(ASSET_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> getSearchParameters() {
        return this.searchParams;
    }

    public Map<String, String> getAssetSearchParameters() {
        return this.assetSearchParams;
    }

    public Repository getRepository(String repository) {
        return this.repoAdapter.getReadableRepository(repository);
    }

    public List<SearchFilter> getSearchFilters(UriInfo uriInfo) {
        return this.convertParameters(uriInfo, Arrays.asList(CONTINUATION_TOKEN, SORT_FIELD, SORT_DIRECTION));
    }

    private List<SearchFilter> convertParameters(UriInfo uriInfo, List<String> keys) {
        return uriInfo.getQueryParameters().entrySet().stream().filter(entry -> !keys.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream().map(value -> {
            String key = this.searchParams.getOrDefault(entry.getKey(), (String)entry.getKey());
            return new SearchFilter(key, (String)value);
        })).collect(Collectors.toList());
    }

    public boolean isAssetSearchParam(String assetSearchParam) {
        return this.assetSearchParams.containsKey(assetSearchParam) || this.isFullAssetAttributeName(assetSearchParam);
    }

    public boolean isFullAssetAttributeName(String assetSearchParam) {
        return assetSearchParam.startsWith(ASSET_PREFIX);
    }

    public String getFullAssetAttributeName(String key) {
        return this.isFullAssetAttributeName(key) ? key : this.getAssetSearchParameters().get(key);
    }
}

