/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.query.SearchFilter;

public class SearchRequest {
    private static final int DEFAULT_LIMIT = 100;
    private final boolean checkAuthorization;
    private final List<SearchFilter> searchFilters;
    private final List<String> repositories;
    private final String sortField;
    private final String continuationToken;
    private final SortDirection sortDirection;
    private final int limit;
    private final Integer offset;
    private final boolean conjunction;
    private final boolean includeAssets;

    private SearchRequest(Builder builder) {
        this.checkAuthorization = builder.checkAuthorization;
        this.searchFilters = builder.searchFilters;
        this.repositories = builder.repositories;
        this.sortField = builder.sortField;
        this.continuationToken = builder.continuationToken;
        this.sortDirection = builder.sortDirection;
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.conjunction = builder.conjunction;
        this.includeAssets = builder.includeAssets;
    }

    public boolean isCheckAuthorization() {
        return this.checkAuthorization;
    }

    public List<SearchFilter> getSearchFilters() {
        return this.searchFilters;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public String getSortField() {
        return this.sortField;
    }

    @Nullable
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nullable
    public Integer getOffset() {
        return this.offset;
    }

    public boolean isConjunction() {
        return this.conjunction;
    }

    public boolean isIncludeAssets() {
        return this.includeAssets;
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SearchRequest(Builder builder, SearchRequest searchRequest) {
        this(builder);
    }

    public static class Builder {
        private boolean checkAuthorization = true;
        private List<SearchFilter> searchFilters = new ArrayList<SearchFilter>();
        private List<String> repositories = new ArrayList<String>();
        private String sortField;
        private SortDirection sortDirection;
        private String continuationToken;
        private Integer limit;
        private Integer offset;
        private boolean conjunction = true;
        private boolean includeAssets = false;

        public Builder disableAuthorization() {
            this.checkAuthorization = false;
            return this;
        }

        public Builder searchFilter(String field, String value) {
            this.searchFilters.add(new SearchFilter(field, value));
            return this;
        }

        public Builder searchFilters(Collection<SearchFilter> searchFilters) {
            this.searchFilters.addAll(searchFilters);
            return this;
        }

        public Builder repository(String repositoryName) {
            this.repositories.add(repositoryName);
            return this;
        }

        public Builder repositories(String ... repositoryNames) {
            this.repositories.addAll(Arrays.asList(repositoryNames));
            return this;
        }

        public Builder repositories(Collection<String> repositoryNames) {
            this.repositories.addAll(repositoryNames);
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public Builder disjunction() {
            this.conjunction = false;
            return this;
        }

        public Builder includeAssets() {
            this.includeAssets = true;
            return this;
        }

        public Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public SearchRequest build() {
            if (this.limit == null) {
                this.limit = 100;
            }
            return new SearchRequest(this, null);
        }
    }
}

