/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.routing.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class RoutingRuleHandler
extends ComponentSupport
implements Handler,
org.sonatype.nexus.repository.routing.RoutingRuleHandler {
    static final String PATH_IS_BLOCKED = "Routing rules block the requested item from this repository";
    private final RoutingRuleHelper routingRuleHelper;

    @Inject
    public RoutingRuleHandler(RoutingRuleHelper routingRuleHelper) {
        this.routingRuleHelper = (RoutingRuleHelper)Preconditions.checkNotNull((Object)routingRuleHelper);
    }

    public Response handle(Context context) throws Exception {
        String path;
        Repository repository = context.getRepository();
        boolean isRoutingRuleAllowed = this.routingRuleHelper.isAllowed(repository, path = this.path(context.getRequest()));
        if (!isRoutingRuleAllowed) {
            String repositoryType = repository.getType().getValue();
            String repositoryName = repository.getName();
            this.log.debug("Routing rules block the requested item for Repository{name='{}', type={}}", (Object)repositoryName, (Object)repositoryType);
            return HttpResponses.forbidden((String)PATH_IS_BLOCKED);
        }
        return context.proceed();
    }

    private String path(Request request) {
        if (request.getParameters().size() == 0) {
            return request.getPath();
        }
        StringBuilder sb = new StringBuilder();
        request.getParameters().forEach(entry -> {
            StringBuilder stringBuilder2 = sb.append('&').append((String)entry.getKey()).append('=').append((String)entry.getValue());
        });
        sb.replace(0, 1, "?");
        return String.valueOf(request.getPath()) + sb;
    }
}

