/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc.sql;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.rest.SearchResourceExtension;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;
import org.sonatype.nexus.repository.rest.internal.resources.SearchResource;
import org.sonatype.nexus.repository.rest.internal.resources.SearchResultFilterUtils;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SearchUtils;
import org.sonatype.nexus.rest.Page;

@Named
@Singleton
@Path(value="/v1/search")
public class SqlSearchResource
extends SearchResource {
    private static final String SQL_SEARCH_RESTRICTIONS = "All searches require at least one criterion of at least three characters before a trailing wildcard (\\*) and cannot start with a wildcard (\\*). Enclose your criteria in quotation marks to search an exact phrase; otherwise, search criteria will be split by any commas, spaces, dashes, or forward slashes.";

    @Inject
    public SqlSearchResource(SearchUtils searchUtils, SearchResultFilterUtils searchResultFilterUtils, SearchService searchService, ComponentXOFactory componentXOFactory, Set<SearchResourceExtension> searchResourceExtensions, EventManager eventManager, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        super(searchUtils, searchResultFilterUtils, searchService, componentXOFactory, searchResourceExtensions, eventManager, assetDescriptors);
    }

    @Override
    @GET
    @ApiOperation(value="Search components", notes="All searches require at least one criterion of at least three characters before a trailing wildcard (\\*) and cannot start with a wildcard (\\*). Enclose your criteria in quotation marks to search an exact phrase; otherwise, search criteria will be split by any commas, spaces, dashes, or forward slashes.")
    public Page<ComponentXO> search(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned", allowEmptyValue=true) @QueryParam(value="continuationToken") String continuationToken, @ApiParam(value="The field to sort the results against, if left empty, a sort based on match weight will be used.", allowEmptyValue=true, allowableValues="group, name, version, repository") @QueryParam(value="sort") String sort, @ApiParam(value="The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')", allowEmptyValue=true, allowableValues="asc, desc") @QueryParam(value="direction") String direction, @ApiParam(value="How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.", allowEmptyValue=true) @Nullable @QueryParam(value="timeout") Integer seconds, @Context UriInfo uriInfo) {
        return super.search(continuationToken, sort, direction, seconds, uriInfo);
    }

    @Override
    @GET
    @Path(value="/assets")
    @ApiOperation(value="Search assets", notes="All searches require at least one criterion of at least three characters before a trailing wildcard (\\*) and cannot start with a wildcard (\\*). Enclose your criteria in quotation marks to search an exact phrase; otherwise, search criteria will be split by any commas, spaces, dashes, or forward slashes.")
    public Page<AssetXO> searchAssets(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned") @QueryParam(value="continuationToken") String continuationToken, @ApiParam(value="The field to sort the results against, if left empty, a sort based on match weight will be used.", allowEmptyValue=true, allowableValues="group, name, version, repository") @QueryParam(value="sort") String sort, @ApiParam(value="The direction to sort records in, defaults to ascending ('asc') for all sort fields, except version, which defaults to descending ('desc')", allowEmptyValue=true, allowableValues="asc, desc") @QueryParam(value="direction") String direction, @ApiParam(value="How long to wait for search results in seconds. If this value is not provided, the system default timeout will be used.", allowEmptyValue=true) @Nullable @QueryParam(value="timeout") Integer seconds, @Context UriInfo uriInfo) {
        return super.searchAssets(continuationToken, sort, direction, seconds, uriInfo);
    }
}

