/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.repository.rest.api.RoutingRuleXO;

@Api(value="Routing rules")
public interface RoutingRulesApiResourceDoc {
    @ApiOperation(value="Create a single routing rule")
    @ApiResponses(value={@ApiResponse(code=204, message="Routing rule was successfully created"), @ApiResponse(code=400, message="A routing rule with the same name already exists or required parameters missing"), @ApiResponse(code=403, message="Insufficient permissions to create routing rule")})
    public void createRoutingRule(@ApiParam(value="A routing rule configuration", required=true) @NotNull RoutingRuleXO var1);

    @ApiOperation(value="List routing rules")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to read routing rules")})
    public List<RoutingRuleXO> getRoutingRules();

    @ApiOperation(value="Get a single routing rule")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to read routing rules"), @ApiResponse(code=404, message="Routing rule not found")})
    public RoutingRuleXO getRoutingRule(@ApiParam(value="The name of the routing rule to get", required=true) String var1);

    @ApiOperation(value="Update a single routing rule")
    @ApiResponses(value={@ApiResponse(code=204, message="Routing rule was successfully updated"), @ApiResponse(code=400, message="Another routing rule with the same name already exists or required parameters missing"), @ApiResponse(code=403, message="Insufficient permissions to edit routing rules"), @ApiResponse(code=404, message="Routing rule not found")})
    public void updateRoutingRule(@ApiParam(value="The name of the routing rule to update", required=true) String var1, @ApiParam(value="A routing rule configuration", required=true) @NotNull RoutingRuleXO var2);

    @ApiOperation(value="Delete a single routing rule")
    @ApiResponses(value={@ApiResponse(code=204, message="Routing rule was successfully deleted"), @ApiResponse(code=403, message="Insufficient permissions to delete routing rules"), @ApiResponse(code=404, message="Routing rule not found")})
    public void deleteRoutingRule(@ApiParam(value="The name of the routing rule to delete", required=true) String var1);
}

