/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiCreateRequest;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiResponse;
import org.sonatype.nexus.repository.rest.api.ContentSelectorApiUpdateRequest;

@Api(value="Content selectors")
public interface ContentSelectorsResourceDoc {
    public static final String NAME_DESCRIPTION = "The content selector name cannot be changed after creation";
    public static final String TYPE_DESCRIPTION = "The type of content selector the backend is using";
    public static final String TYPE_ALLOWED_VALUES = "csel, jexl";
    public static final String TYPE_NOTES = "All new content selectors will be created as csel selectors, jexl selectors are deprecated";
    public static final String DESCRIPTION_DESCRIPTION = "A human-readable description";
    public static final String EXPRESSION_DESCRIPTION = "The expression used to identify content";
    public static final String EXPRESSION_EXAMPLE = "format == \"maven2\" and path =^ \"/org/sonatype/nexus\"";
    public static final String EXPRESSION_NOTES = "See http://links.sonatype.com/products/nexus/selectors/docs for more details";

    @ApiOperation(value="List content selectors")
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation", response=ContentSelectorApiResponse.class, responseContainer="List"), @ApiResponse(code=403, message="Insufficient permissions to read content selectors")})
    public List<ContentSelectorApiResponse> getContentSelectors();

    @ApiOperation(value="Create a new content selector")
    @ApiResponses(value={@ApiResponse(code=204, message="Content selector successfully created"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="Insufficient permissions to create content selectors")})
    public void createContentSelector(@Valid ContentSelectorApiCreateRequest var1);

    @ApiOperation(value="Get a content selector by name")
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation", response=ContentSelectorApiResponse.class), @ApiResponse(code=403, message="Insufficient permissions to read the content selector")})
    public ContentSelectorApiResponse getContentSelector(@ApiParam(required=true, value="The content selector name") String var1);

    @ApiOperation(value="Update a content selector")
    @ApiResponses(value={@ApiResponse(code=204, message="Content selector updated successfully"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="Insufficient permissions to update the content selector")})
    public void updateContentSelector(@ApiParam(required=true, value="The content selector name") String var1, @Valid ContentSelectorApiUpdateRequest var2);

    @ApiOperation(value="Delete a content selector")
    @ApiResponses(value={@ApiResponse(code=204, message="Content selector deleted successfully"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="Insufficient permissions to delete the content selector")})
    public void deleteContentSelector(String var1);
}

