/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchUtils;

@Named
@Singleton
public class SearchResultFilterUtils {
    private static final String EMPTY_PARAM = "";
    private final SearchUtils searchUtils;
    private final Map<String, SearchMapping> mappingsByAttribute;

    @Inject
    public SearchResultFilterUtils(SearchUtils searchUtils, List<SearchMapping> mappings) {
        this.searchUtils = (SearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)searchUtils)));
        this.mappingsByAttribute = ((List)Preconditions.checkNotNull(mappings)).stream().collect(Collectors.toMap(SearchMapping::getAttribute, Function.identity()));
    }

    @VisibleForTesting
    static Optional<Object> getValueFromAssetMap(AssetSearchResult asset, String identifier) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            return Optional.empty();
        }
        ArrayList keys = Lists.newArrayList((Object[])identifier.split("\\."));
        if ("assets".equals(keys.get(0))) {
            keys.remove(0);
        }
        switch ((String)keys.get(0)) {
            case "contentType": {
                return Optional.of(asset.getContentType());
            }
            case "format": {
                return Optional.of(asset.getFormat());
            }
            case "id": {
                return Optional.of(asset.getId());
            }
            case "path": {
                return Optional.of(asset.getPath());
            }
        }
        Map<String, String> value = Collections.emptyMap();
        if (!keys.isEmpty() && "attributes".equals(keys.get(0))) {
            keys.remove(0);
            value = asset.getAttributes();
            if (!keys.isEmpty() && "checksum".equals(keys.get(0))) {
                keys.remove(0);
                value = asset.getChecksum();
            }
        }
        for (String key : keys) {
            if (value == null) {
                return Optional.empty();
            }
            value = value.get(key);
        }
        return Optional.ofNullable(value);
    }

    public Stream<AssetSearchResult> filterComponentAssets(ComponentSearchResult component, MultivaluedMap<String, String> assetParams) {
        Map<String, String> assetParamMap = assetParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
        if (assetParams.isEmpty()) {
            return component.getAssets().stream();
        }
        return component.getAssets().stream().filter(asset -> this.filterAsset((AssetSearchResult)asset, assetParamMap));
    }

    @VisibleForTesting
    boolean filterAsset(AssetSearchResult asset, Map<String, String> assetParams) {
        if (SearchResultFilterUtils.excludeAsset(asset, this.getEmptyAssetParams(assetParams))) {
            return false;
        }
        Map<String, String> assetParamsWithValues = this.getNonEmptyAssetParams(assetParams);
        if (assetParamsWithValues.isEmpty()) {
            return true;
        }
        return assetParamsWithValues.entrySet().stream().allMatch(entry -> this.keepAsset(asset, (String)entry.getKey(), (String)entry.getValue()));
    }

    @VisibleForTesting
    static boolean excludeAsset(AssetSearchResult asset, List<String> paramFilters) {
        return paramFilters.stream().anyMatch(filter -> SearchResultFilterUtils.getValueFromAssetMap(asset, filter).isPresent());
    }

    @VisibleForTesting
    boolean keepAsset(AssetSearchResult asset, String paramKey, String paramValue) {
        return SearchResultFilterUtils.getValueFromAssetMap(asset, paramKey).map(Object::toString).map(this.matches(asset, paramKey, paramValue)).orElse(false);
    }

    Function<String, Boolean> matches(AssetSearchResult asset, String paramKey, String paramValue) {
        return result -> {
            boolean exactMatch = Optional.ofNullable(this.mappingsByAttribute.get(paramKey)).map(SearchMapping::isExactMatch).orElse(true);
            if (exactMatch) {
                return result.toLowerCase().equals(paramValue.toLowerCase());
            }
            return result.toLowerCase().contains(paramValue.toLowerCase());
        };
    }

    @VisibleForTesting
    List<String> getEmptyAssetParams(Map<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> EMPTY_PARAM.equals(entry.getValue())).map(e -> this.searchUtils.getFullAssetAttributeName((String)e.getKey())).collect(Collectors.toList());
    }

    @VisibleForTesting
    Map<String, String> getNonEmptyAssetParams(Map<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> !EMPTY_PARAM.equals(entry.getValue())).collect(Collectors.toMap(entry -> this.searchUtils.getFullAssetAttributeName((String)entry.getKey()), Map.Entry::getValue));
    }
}

