/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.SearchResourceExtension;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.internal.resources.AssetDownloadResponseProcessor;
import org.sonatype.nexus.repository.rest.internal.resources.SearchResultFilterUtils;
import org.sonatype.nexus.repository.rest.internal.resources.doc.SearchResourceDoc;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SearchUtils;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.event.SearchEvent;
import org.sonatype.nexus.repository.search.event.SearchEventSource;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/search")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@FeatureFlag(name="nexus.elasticsearch.enabled", enabledByDefault=true)
public class SearchResource
extends ComponentSupport
implements Resource,
SearchResourceDoc {
    public static final String RESOURCE_URI = "/v1/search";
    public static final String SEARCH_ASSET_URI = "/assets";
    public static final String SEARCH_AND_DOWNLOAD_URI = "/assets/download";
    private final SearchUtils searchUtils;
    private final SearchResultFilterUtils searchResultFilterUtils;
    private final SearchService searchService;
    private final ComponentXOFactory componentXOFactory;
    private final Set<SearchResourceExtension> searchResourceExtensions;
    private final Map<String, AssetXODescriptor> assetDescriptors;
    private final EventManager eventManager;
    private int pageSize = 50;

    @Inject
    public SearchResource(SearchUtils searchUtils, SearchResultFilterUtils searchResultFilterUtils, SearchService searchService, ComponentXOFactory componentXOFactory, Set<SearchResourceExtension> searchResourceExtensions, EventManager eventManager, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        this.searchUtils = (SearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)searchUtils)));
        this.searchResultFilterUtils = (SearchResultFilterUtils)Preconditions.checkNotNull((Object)searchResultFilterUtils);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.componentXOFactory = (ComponentXOFactory)Preconditions.checkNotNull((Object)componentXOFactory);
        this.searchResourceExtensions = (Set)Preconditions.checkNotNull(searchResourceExtensions);
        this.assetDescriptors = assetDescriptors;
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    @GET
    public Page<ComponentXO> search(@QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="sort") String sort, @QueryParam(value="direction") String direction, @Nullable @QueryParam(value="timeout") Integer seconds, @Context UriInfo uriInfo) {
        SearchResponse response = this.doSearch(continuationToken, sort, direction, seconds, uriInfo);
        List componentXOs = response.getSearchResults().stream().map(this::toComponent).collect(Collectors.toList());
        return new Page(componentXOs, response.getContinuationToken());
    }

    @Override
    @GET
    @Path(value="/assets")
    public Page<AssetXO> searchAssets(@QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="sort") String sort, @QueryParam(value="direction") String direction, @Nullable @QueryParam(value="timeout") Integer seconds, @Context UriInfo uriInfo) {
        return this.assetSearch(continuationToken, sort, direction, seconds, uriInfo);
    }

    @Override
    @GET
    @Path(value="/assets/download")
    public Response searchAndDownloadAssets(@QueryParam(value="sort") String sort, @QueryParam(value="direction") String direction, @QueryParam(value="timeout") Integer seconds, @Context UriInfo uriInfo) {
        Page<AssetXO> assets = this.assetSearch(null, sort, direction, seconds, uriInfo);
        return new AssetDownloadResponseProcessor(assets.getItems(), !Strings2.isEmpty((String)sort)).process();
    }

    private Page<AssetXO> assetSearch(String continuationToken, String sort, String direction, Integer seconds, UriInfo uriInfo) {
        SearchResponse response = this.doSearch(continuationToken, sort, direction, seconds, uriInfo);
        if (response.getSearchResults().isEmpty()) {
            return new Page(Collections.emptyList(), null);
        }
        MultivaluedMap<String, String> assetParams = this.getAssetParams(uriInfo);
        List assets = response.getSearchResults().stream().flatMap(component -> this.searchResultFilterUtils.filterComponentAssets((ComponentSearchResult)component, assetParams)).map(asset -> AssetXO.from(asset, this.searchUtils.getRepository(asset.getRepository()), this.assetDescriptors)).collect(Collectors.toList());
        return new Page(assets, response.getContinuationToken());
    }

    private SearchResponse doSearch(String continuationToken, String sort, String direction, Integer seconds, UriInfo uriInfo) {
        List<SearchFilter> searchFilters = this.searchUtils.getSearchFilters(uriInfo);
        this.fireSearchEvent(searchFilters);
        SearchRequest request = SearchRequest.builder().searchFilters(searchFilters).continuationToken(continuationToken).limit(this.getPageSize()).sortField(sort).sortDirection(Optional.ofNullable(direction).map(String::toUpperCase).map(SortDirection::valueOf).orElse(null)).includeAssets().build();
        return this.searchService.search(request);
    }

    private ComponentXO toComponent(ComponentSearchResult componentHit) {
        ComponentXO componentXO = this.componentXOFactory.createComponentXO();
        Repository repository = this.searchUtils.getRepository(componentHit.getRepositoryName());
        componentXO.setGroup(componentHit.getGroup());
        componentXO.setName(componentHit.getName());
        componentXO.setVersion(componentHit.getVersion());
        componentXO.setId(new RepositoryItemIDXO(repository.getName(), componentHit.getId()).getValue());
        componentXO.setRepository(componentHit.getRepositoryName());
        componentXO.setFormat(componentHit.getFormat());
        List<AssetXO> assets = componentHit.getAssets().stream().map(asset -> AssetXO.from(asset, repository, this.assetDescriptors)).collect(Collectors.toList());
        componentXO.setAssets(assets);
        for (SearchResourceExtension searchResourceExtension : this.searchResourceExtensions) {
            componentXO = searchResourceExtension.updateComponentXO(componentXO, componentHit);
        }
        return componentXO;
    }

    @VisibleForTesting
    MultivaluedMap<String, String> getAssetParams(UriInfo uriInfo) {
        return (MultivaluedMap)uriInfo.getQueryParameters().entrySet().stream().filter(t -> this.searchUtils.isAssetSearchParam((String)t.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, MultivaluedHashMap::new));
    }

    private int getPageSize() {
        return this.pageSize;
    }

    @VisibleForTesting
    void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private void fireSearchEvent(Collection<SearchFilter> searchFilters) {
        this.eventManager.post((Object)new SearchEvent(searchFilters, SearchEventSource.REST));
    }
}

