/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.rest.api.RoutingRuleXO;
import org.sonatype.nexus.repository.rest.internal.resources.doc.RoutingRulesApiResourceDoc;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RoutingRulesApiResource
extends ComponentSupport
implements Resource,
RoutingRulesApiResourceDoc {
    private final RoutingRuleStore routingRuleStore;
    private final RoutingRuleHelper routingRuleHelper;

    @Inject
    public RoutingRulesApiResource(RoutingRuleStore routingRuleStore, RoutingRuleHelper routingRuleHelper) {
        this.routingRuleStore = (RoutingRuleStore)Preconditions.checkNotNull((Object)routingRuleStore);
        this.routingRuleHelper = (RoutingRuleHelper)Preconditions.checkNotNull((Object)routingRuleHelper);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void createRoutingRule(@NotNull RoutingRuleXO routingRuleXO) {
        RoutingRule routingRule = this.routingRuleStore.newRoutingRule();
        routingRule.name(routingRuleXO.getName());
        routingRule.description(routingRuleXO.getDescription());
        routingRule.mode(routingRuleXO.getMode());
        routingRule.matchers(routingRuleXO.getMatchers());
        this.routingRuleStore.create(routingRule);
    }

    @Override
    @GET
    public List<RoutingRuleXO> getRoutingRules() {
        this.routingRuleHelper.ensureUserHasPermissionToRead();
        return this.routingRuleStore.list().stream().map(RoutingRuleXO::fromRoutingRule).collect(Collectors.toList());
    }

    @Override
    @GET
    @Path(value="/{name}")
    public RoutingRuleXO getRoutingRule(@PathParam(value="name") String name) {
        this.routingRuleHelper.ensureUserHasPermissionToRead();
        RoutingRule routingRule = this.getRuleFromStore(name);
        return RoutingRuleXO.fromRoutingRule(routingRule);
    }

    @Override
    @PUT
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void updateRoutingRule(@PathParam(value="name") String name, @NotNull RoutingRuleXO routingRuleXO) {
        RoutingRule routingRule = this.getRuleFromStore(name);
        routingRule.name(routingRuleXO.getName()).description(routingRuleXO.getDescription()).mode(routingRuleXO.getMode()).matchers(routingRuleXO.getMatchers());
        this.routingRuleStore.update(routingRule);
    }

    @Override
    @DELETE
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void deleteRoutingRule(@PathParam(value="name") String name) {
        RoutingRule routingRule = this.getRuleFromStore(name);
        EntityId routingRuleId = routingRule.id();
        Map assignedRepositories = this.routingRuleHelper.calculateAssignedRepositories();
        List repositories = assignedRepositories.computeIfAbsent(routingRuleId, id -> Collections.emptyList());
        if (!repositories.isEmpty()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"Routing rule is still in use by " + repositories.size() + " repositories.\""), "application/json");
        }
        this.routingRuleStore.delete(routingRule);
    }

    private RoutingRule getRuleFromStore(String name) {
        RoutingRule routingRule = this.routingRuleStore.getByName(name);
        if (routingRule == null) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"Did not find a routing rule with the name '" + name + "'\""), "application/json");
        }
        return routingRule;
    }
}

