/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.internal.BlobStoreMultipartForm;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;

public class ComponentUploadUtils {
    private ComponentUploadUtils() {
    }

    public static ComponentUpload createComponentUpload(String format, BlobStoreMultipartForm multipartInput) throws IOException {
        Map<String, BlobStoreMultipartForm.TempBlobFormField> assetsPayloads = ComponentUploadUtils.mapFields(format, multipartInput.getFiles());
        Map<String, String> formFields = ComponentUploadUtils.mapFields(format, multipartInput.getFormFields());
        HashMap assetFields = new HashMap();
        HashMap<String, String> componentFields = new HashMap<String, String>();
        formFields.forEach((key, value) -> {
            boolean isAssetField;
            if (Strings2.isBlank((String)value)) {
                return;
            }
            int indexOfDot = key.indexOf(46);
            boolean bl = isAssetField = indexOfDot != -1 && key.length() > indexOfDot + 2 && assetsPayloads.containsKey(key.substring(0, indexOfDot));
            if (isAssetField) {
                String assetName = key.substring(0, indexOfDot);
                assetFields.putIfAbsent(assetName, new HashMap());
                ((Map)assetFields.get(assetName)).put(key.substring(indexOfDot + 1), value);
            } else {
                componentFields.put((String)key, (String)value);
            }
        });
        List<AssetUpload> assetUploads = assetsPayloads.entrySet().stream().map(asset -> ComponentUploadUtils.createAssetUpload((BlobStoreMultipartForm.TempBlobFormField)asset.getValue(), (Map)assetFields.get(asset.getKey()))).collect(Collectors.toList());
        ComponentUpload componentUpload = new ComponentUpload();
        componentUpload.setFields(componentFields);
        componentUpload.setAssetUploads(assetUploads);
        return componentUpload;
    }

    private static <T> Map<String, T> mapFields(String format, Map<String, T> assetBlobs) {
        if (format == null) {
            return assetBlobs;
        }
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, T> formField : assetBlobs.entrySet()) {
            if (formField.getKey().startsWith(String.valueOf(format) + '.')) {
                result.put(formField.getKey().substring(format.length() + 1), formField.getValue());
                continue;
            }
            result.put(formField.getKey(), formField.getValue());
        }
        return result;
    }

    private static AssetUpload createAssetUpload(BlobStoreMultipartForm.TempBlobFormField assetPayload, Map<String, String> assetFields) {
        AssetUpload assetUpload = new AssetUpload();
        assetUpload.setPayload((PartPayload)new TempBlobPartPayload(assetPayload.getFieldName(), false, assetPayload.getFileName(), null, assetPayload.getTempBlob()));
        if (assetFields != null) {
            assetUpload.setFields(assetFields);
        }
        return assetUpload;
    }
}

