/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal;

import com.google.common.collect.ImmutableList;
import io.swagger.models.HttpMethod;
import io.swagger.models.parameters.QueryParameter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappingsService;
import org.sonatype.nexus.swagger.ParameterContributor;

@Named
@Singleton
public class SearchParameterContributor
extends ParameterContributor<QueryParameter> {
    private static final List<HttpMethod> HTTP_METHODS = ImmutableList.of((Object)HttpMethod.GET);
    private static final List<String> PATHS = ImmutableList.of((Object)"/v1/search", (Object)"/v1/search/assets", (Object)"/v1/search/assets/download");

    @Inject
    public SearchParameterContributor(SearchMappingsService searchMappings) {
        super(HTTP_METHODS, PATHS, SearchParameterContributor.transformMappings(searchMappings.getAllMappings()));
    }

    private static Collection<QueryParameter> transformMappings(Iterable<SearchMapping> searchMappings) {
        return StreamSupport.stream(searchMappings.spliterator(), false).map(m -> (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(m.getAlias())).type("string")).description(m.getDescription())).collect(Collectors.toList());
    }
}

