/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.validation.constraint.UriString;

public class ProxyAttributes {
    @ApiModelProperty(value="Location of the remote repository being proxied", example="https://remote.repository.com")
    @UriString
    @NotEmpty
    protected final String remoteUrl;
    @ApiModelProperty(value="How long to cache artifacts before rechecking the remote repository (in minutes)", example="1440")
    @NotNull
    protected final Integer contentMaxAge;
    @ApiModelProperty(value="How long to cache metadata before rechecking the remote repository (in minutes)", example="1440")
    @NotNull
    protected final Integer metadataMaxAge;

    @JsonCreator
    public ProxyAttributes(@JsonProperty(value="remoteUrl") String remoteUrl, @JsonProperty(value="contentMaxAge") Integer contentMaxAge, @JsonProperty(value="metadataMaxAge") Integer metadataMaxAge) {
        this.remoteUrl = remoteUrl;
        this.contentMaxAge = contentMaxAge;
        this.metadataMaxAge = metadataMaxAge;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public Integer getContentMaxAge() {
        return this.contentMaxAge;
    }

    public Integer getMetadataMaxAge() {
        return this.metadataMaxAge;
    }
}

