/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.sonatype.nexus.repository.rest.api.model.RepositoryApiRequest;

public abstract class AbstractRepositoryApiRequest
implements RepositoryApiRequest {
    @ApiModelProperty(value="A unique identifier for this repository", example="internal", required=true)
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @NotEmpty
    protected @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @NotEmpty String name;
    @ApiModelProperty(value="Component format used by this repository", hidden=true)
    @NotEmpty
    protected String format;
    @ApiModelProperty(value="Controls if deployments of and updates to artifacts are allowed", allowableValues="hosted,proxy,group", hidden=true)
    @NotEmpty
    protected String type;
    @ApiModelProperty(value="Whether this repository accepts incoming requests", example="true", required=true)
    @NotNull
    protected Boolean online;

    @JsonCreator
    public AbstractRepositoryApiRequest(@JsonProperty(value="name") String name, @JsonProperty(value="format") String format, @JsonProperty(value="type") String type, @JsonProperty(value="online") Boolean online) {
        this.name = name;
        this.format = format;
        this.type = type;
        this.online = online;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Boolean getOnline() {
        return this.online;
    }
}

