/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api.model;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public abstract class AbstractApiRepository {
    @ApiModelProperty(value="A unique identifier for this repository", example="internal")
    @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}")
    @NotEmpty
    protected @Pattern(regexp="^[a-zA-Z0-9\\-]{1}[a-zA-Z0-9_\\-\\.]*$", message="{org.sonatype.nexus.validation.constraint.name}") @NotEmpty String name;
    @ApiModelProperty(value="Component format held in this repository", example="npm")
    @NotEmpty
    protected String format;
    @ApiModelProperty(value="Controls if deployments of and updates to artifacts are allowed", allowableValues="hosted,proxy,group", example="hosted")
    @NotEmpty
    protected String type;
    @ApiModelProperty(value="URL to the repository")
    protected String url;
    @ApiModelProperty(value="Whether this repository accepts incoming requests", example="true")
    @NotNull
    protected Boolean online;

    public AbstractApiRepository(String name, String format, String type, String url, Boolean online) {
        this.name = name;
        this.format = format;
        this.type = type;
        this.url = url;
        this.online = online;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getOnline() {
        return this.online;
    }

    public String getUrl() {
        return this.url;
    }
}

