/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rest.api.ApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.CleanupPolicyAttributes;
import org.sonatype.nexus.repository.rest.api.model.ComponentAttributes;
import org.sonatype.nexus.repository.rest.api.model.GroupDeployAttributes;
import org.sonatype.nexus.repository.rest.api.model.HostedStorageAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientConnectionAttributes;
import org.sonatype.nexus.repository.rest.api.model.HttpClientConnectionAuthenticationAttributes;
import org.sonatype.nexus.repository.rest.api.model.NegativeCacheAttributes;
import org.sonatype.nexus.repository.rest.api.model.ProxyAttributes;
import org.sonatype.nexus.repository.rest.api.model.ReplicationAttributes;
import org.sonatype.nexus.repository.rest.api.model.SimpleApiGroupRepository;
import org.sonatype.nexus.repository.rest.api.model.SimpleApiHostedRepository;
import org.sonatype.nexus.repository.rest.api.model.SimpleApiProxyRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="default")
public class SimpleApiRepositoryAdapter
implements ApiRepositoryAdapter {
    private final RoutingRuleStore routingRuleStore;
    private DatabaseCheck databaseCheck;
    @Inject
    @Named(value="${nexus.replication.http.enabled:-true}")
    private boolean replicationFeatureEnabled;

    @Inject
    @VisibleForTesting
    void setDatabaseCheck(DatabaseCheck databaseCheck) {
        this.databaseCheck = databaseCheck;
    }

    @Inject
    public SimpleApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        this.routingRuleStore = (RoutingRuleStore)Preconditions.checkNotNull((Object)routingRuleStore);
    }

    @Override
    public AbstractApiRepository adapt(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String name = repository.getName();
        String format = repository.getFormat().toString();
        String url = repository.getUrl();
        switch (repository.getType().toString()) {
            case "group": {
                return new SimpleApiGroupRepository(name, format, url, online, this.getStorageAttributes(repository), this.getGroupAttributes(repository));
            }
            case "hosted": {
                return new SimpleApiHostedRepository(name, format, url, online, this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getComponentAttributes(repository));
            }
            case "proxy": {
                return new SimpleApiProxyRepository(name, format, url, online, this.getStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.getReplicationAttributes(repository));
            }
        }
        return null;
    }

    protected ComponentAttributes getComponentAttributes(Repository repository) {
        return new ComponentAttributes((Boolean)repository.getConfiguration().attributes("component").get("proprietaryComponents", Boolean.class, (Object)false));
    }

    protected String getRoutingRuleName(Repository repository) {
        EntityId routingRuleId = repository.getConfiguration().getRoutingRuleId();
        if (routingRuleId == null) {
            return null;
        }
        RoutingRule routingRule = this.routingRuleStore.getById(routingRuleId.getValue());
        return routingRule != null ? routingRule.name() : null;
    }

    protected StorageAttributes getStorageAttributes(Repository repository) {
        NestedAttributesMap configuration = repository.getConfiguration().attributes("storage");
        String blobStoreName = (String)configuration.get("blobStoreName", String.class);
        Boolean strictContentTypeValidation = (Boolean)configuration.get("strictContentTypeValidation", Boolean.class, (Object)Boolean.TRUE);
        return new StorageAttributes(blobStoreName, strictContentTypeValidation);
    }

    protected HostedStorageAttributes getHostedStorageAttributes(Repository repository) {
        NestedAttributesMap configuration = repository.getConfiguration().attributes("storage");
        String blobStoreName = (String)configuration.get("blobStoreName", String.class);
        Boolean strictContentTypeValidation = (Boolean)configuration.get("strictContentTypeValidation", Boolean.class, (Object)Boolean.TRUE);
        String writePolicy = SimpleApiRepositoryAdapter.toString(configuration.get("writePolicy"), "ALLOW");
        return new HostedStorageAttributes(blobStoreName, strictContentTypeValidation, writePolicy);
    }

    protected GroupDeployAttributes getGroupAttributes(Repository repository) {
        NestedAttributesMap groupAttributes = repository.getConfiguration().attributes("group");
        Collection memberNames = (Collection)groupAttributes.get("memberNames", (TypeToken)new TypeToken<Collection<String>>(){});
        String groupWriteMember = (String)groupAttributes.get("groupWriteMember", String.class);
        return new GroupDeployAttributes(memberNames, groupWriteMember);
    }

    protected CleanupPolicyAttributes getCleanupPolicyAttributes(Repository repository) {
        Configuration configuration = repository.getConfiguration();
        if (!configuration.getAttributes().containsKey("cleanup")) {
            return null;
        }
        Collection policyNames = (Collection)configuration.attributes("cleanup").get("policyName", (TypeToken)new TypeToken<Collection<String>>(){}, Collections.emptyList());
        return new CleanupPolicyAttributes(policyNames);
    }

    protected ProxyAttributes getProxyAttributes(Repository repository) {
        NestedAttributesMap configuration = repository.getConfiguration().attributes("proxy");
        String remoteUrl = (String)configuration.get("remoteUrl", String.class);
        Integer contentMaxAge = SimpleApiRepositoryAdapter.toInt((Number)configuration.get("contentMaxAge", Number.class), 1440);
        Integer metadataMaxAge = SimpleApiRepositoryAdapter.toInt((Number)configuration.get("metadataMaxAge", Number.class), 1440);
        return new ProxyAttributes(remoteUrl, contentMaxAge, metadataMaxAge);
    }

    protected NegativeCacheAttributes getNegativeCacheAttributes(Repository repository) {
        NestedAttributesMap configuration = repository.getConfiguration().attributes("negativeCache");
        Boolean enabled = (Boolean)configuration.get("enabled", Boolean.class, (Object)true);
        Integer timeToLive = SimpleApiRepositoryAdapter.toInt((Number)configuration.get("timeToLive", Number.class, (Object)Time.hours((long)24L).toMinutesI()));
        return new NegativeCacheAttributes(enabled, timeToLive);
    }

    protected HttpClientAttributes getHttpClientAttributes(Repository repository) {
        Configuration configuration = repository.getConfiguration();
        NestedAttributesMap httpclient = configuration.attributes("httpclient");
        Boolean blocked = (Boolean)httpclient.get("blocked", Boolean.class, (Object)false);
        Boolean autoBlock = (Boolean)httpclient.get("autoBlock", Boolean.class, (Object)false);
        HttpClientConnectionAuthenticationAttributes authentication = null;
        if (httpclient.contains("authentication")) {
            NestedAttributesMap authenticationMap = httpclient.child("authentication");
            String type = (String)authenticationMap.get("type", String.class);
            String username = (String)authenticationMap.get("username", String.class);
            String ntlmHost = (String)authenticationMap.get("ntlmHost", String.class);
            String ntlmDomain = (String)authenticationMap.get("ntlmDomain", String.class);
            authentication = new HttpClientConnectionAuthenticationAttributes(type, username, null, ntlmHost, ntlmDomain);
        }
        HttpClientConnectionAttributes connection = null;
        if (httpclient.contains("connection")) {
            NestedAttributesMap connectionMap = httpclient.child("connection");
            Integer retries = SimpleApiRepositoryAdapter.toInt((Number)connectionMap.get("retries", Number.class));
            String userAgentSuffix = (String)connectionMap.get("userAgentSuffix", String.class);
            Integer timeout = SimpleApiRepositoryAdapter.toInt((Number)connectionMap.get("timeout", Number.class));
            Boolean enableCircularRedirects = (Boolean)connectionMap.get("enableCircularRedirects", Boolean.class, (Object)Boolean.FALSE);
            Boolean enableCookies = (Boolean)connectionMap.get("enableCookies", Boolean.class, (Object)Boolean.FALSE);
            Boolean useTrustStore = (Boolean)connectionMap.get("useTrustStore", Boolean.class, (Object)Boolean.FALSE);
            connection = new HttpClientConnectionAttributes(retries, userAgentSuffix, timeout, enableCircularRedirects, enableCookies, useTrustStore);
        }
        return new HttpClientAttributes(blocked, autoBlock, connection, authentication);
    }

    protected ReplicationAttributes getReplicationAttributes(Repository repository) {
        boolean isPostgresql = this.databaseCheck == null ? false : this.databaseCheck.isPostgresql();
        Configuration configuration = repository.getConfiguration();
        NestedAttributesMap replication = configuration.attributes("replication");
        if (!this.replicationFeatureEnabled || replication == null || !isPostgresql) {
            return null;
        }
        Boolean preemptivePull = (Boolean)replication.get("preemptivePullEnabled", Boolean.class, (Object)Boolean.FALSE);
        String assetPathRegex = (String)replication.get("assetPathRegex", String.class);
        return new ReplicationAttributes(preemptivePull, assetPathRegex);
    }

    protected static String toString(Object o, Object defaultValue) {
        return (o == null ? defaultValue : o).toString();
    }

    protected static Integer toInt(Number num) {
        return num == null ? null : Integer.valueOf(num.intValue());
    }

    protected static Integer toInt(Number num, Integer defaultValue) {
        return num == null ? defaultValue.intValue() : num.intValue();
    }
}

