/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.ApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.AuthorizingRepositoryManager;
import org.sonatype.nexus.repository.rest.api.RepositorySettingsApiResourceDoc;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.rest.Resource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RepositorySettingsApiResource
extends ComponentSupport
implements Resource,
RepositorySettingsApiResourceDoc {
    private final AuthorizingRepositoryManager authorizingRepositoryManager;
    private final Map<String, ApiRepositoryAdapter> convertersByFormat;
    private final ApiRepositoryAdapter defaultAdapter;

    @Inject
    public RepositorySettingsApiResource(AuthorizingRepositoryManager authorizingRepositoryManager, @Named(value="default") @Named(value="default") ApiRepositoryAdapter defaultAdapter, Map<String, ApiRepositoryAdapter> convertersByFormat) {
        this.authorizingRepositoryManager = (AuthorizingRepositoryManager)Preconditions.checkNotNull((Object)authorizingRepositoryManager);
        this.defaultAdapter = (ApiRepositoryAdapter)Preconditions.checkNotNull((Object)defaultAdapter);
        this.convertersByFormat = (Map)Preconditions.checkNotNull(convertersByFormat);
    }

    @Override
    @RequiresAuthentication
    @GET
    public List<AbstractApiRepository> getRepositories() {
        return this.authorizingRepositoryManager.getRepositoriesWithAdmin().stream().map(this::convert).collect(Collectors.toList());
    }

    private AbstractApiRepository convert(Repository repository) {
        return this.convertersByFormat.getOrDefault(repository.getFormat().toString(), this.defaultAdapter).adapt(repository);
    }
}

