/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.AbstractRepositoriesApiResource;
import org.sonatype.nexus.repository.rest.api.FormatAndType;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.AbstractRepositoryApiRequest;
import org.sonatype.nexus.repository.rest.api.model.GroupAttributes;
import org.sonatype.nexus.repository.rest.api.model.GroupDeployAttributes;
import org.sonatype.nexus.repository.rest.api.model.GroupRepositoryApiRequest;
import org.sonatype.nexus.repository.rest.api.model.SimpleApiGroupRepository;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;
import org.sonatype.nexus.validation.Validate;

public abstract class AbstractGroupRepositoriesApiResource<T extends GroupRepositoryApiRequest>
extends AbstractRepositoriesApiResource<T> {
    private static final String WRITABLE_MEMBER = "writableMember";
    private ConstraintViolationFactory constraintViolationFactory;
    private ApplicationVersion applicationVersion;

    @Inject
    public void setConstraintViolationFactory(ConstraintViolationFactory constraintViolationFactory) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
    }

    @Inject
    public void setApplicationVersion(ApplicationVersion applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    @POST
    @RequiresAuthentication
    @Validate
    public Response createRepository(T request) {
        this.validateRequest(request);
        return super.createRepository(request);
    }

    @Override
    @PUT
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    public Response updateRepository(T request, @PathParam(value="repositoryName") String repositoryName) {
        this.validateRequest(request);
        return super.updateRepository(request, repositoryName);
    }

    private void validateRequest(T request) {
        String groupFormat = ((AbstractRepositoryApiRequest)request).getFormat();
        HashSet violations = Sets.newHashSet();
        Collection<String> memberNames = ((GroupRepositoryApiRequest)request).getGroup().getMemberNames();
        for (String repositoryName : memberNames) {
            Repository repository = this.repositoryManager.get(repositoryName);
            if (Objects.nonNull(repository)) {
                String memberFormat = repository.getFormat().getValue();
                if (memberFormat.equals(groupFormat)) continue;
                violations.add(this.constraintViolationFactory.createViolation("memberNames", "Member repository format does not match group repository format: " + repositoryName));
                continue;
            }
            violations.add(this.constraintViolationFactory.createViolation("memberNames", "Member repository does not exist: " + repositoryName));
        }
        this.validateGroupDeploy(request, violations);
        ConstraintViolations.maybePropagate((Set)violations, (Logger)this.log);
    }

    private void validateGroupDeploy(T request, Set<ConstraintViolation<?>> violations) {
        GroupAttributes group = ((GroupRepositoryApiRequest)request).getGroup();
        if (group instanceof GroupDeployAttributes) {
            GroupDeployAttributes groupDeployAttributes = (GroupDeployAttributes)group;
            String writableMember = groupDeployAttributes.getWritableMember();
            if (writableMember == null || writableMember.isEmpty()) {
                return;
            }
            Repository writableMemberRepository = this.repositoryManager.get(writableMember);
            if (!"PRO".equals(this.applicationVersion.getEdition())) {
                violations.add(this.constraintViolationFactory.createViolation(WRITABLE_MEMBER, "Deploying to groups is a PRO-licensed feature. See https://links.sonatype.com/product-nexus-repository"));
            } else if (writableMemberRepository == null) {
                violations.add(this.constraintViolationFactory.createViolation(WRITABLE_MEMBER, "Writable member repository does not exist"));
            } else if (!writableMemberRepository.getType().getValue().equals("hosted")) {
                violations.add(this.constraintViolationFactory.createViolation(WRITABLE_MEMBER, "Writable member must be a hosted repository"));
            } else if (!writableMemberRepository.getFormat().getValue().equals(((AbstractRepositoryApiRequest)request).getFormat())) {
                violations.add(this.constraintViolationFactory.createViolation(WRITABLE_MEMBER, "Writable member repository format does not match group repository format: " + writableMember));
            } else if (!((GroupRepositoryApiRequest)request).getGroup().getMemberNames().contains(writableMember)) {
                violations.add(this.constraintViolationFactory.createViolation(WRITABLE_MEMBER, "Writable member must be a member of the group"));
            }
        }
    }

    @Override
    @GET
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    @ApiOperation(value="Get repository", response=SimpleApiGroupRepository.class)
    public AbstractApiRepository getRepository(@ApiParam(hidden=true) @BeanParam FormatAndType formatAndType, @PathParam(value="repositoryName") String repositoryName) {
        return super.getRepository(formatAndType, repositoryName);
    }
}

