/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonatype.nexus.repository.rest.sql.SearchField;

public class SearchMapping {
    private final String attribute;
    private final String alias;
    private final String description;
    private final SearchField field;
    private final boolean exactMatch;

    public SearchMapping(String alias, String attribute, String description, SearchField field) {
        this(alias, attribute, description, field, true);
    }

    public SearchMapping(String alias, String attribute, String description, SearchField field, boolean exactMatch) {
        this.alias = (String)Preconditions.checkNotNull((Object)alias);
        this.attribute = (String)Preconditions.checkNotNull((Object)attribute);
        this.description = (String)Preconditions.checkNotNull((Object)description);
        this.field = (SearchField)((Object)Preconditions.checkNotNull((Object)((Object)field)));
        this.exactMatch = exactMatch;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchField getField() {
        return this.field;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchMapping that = (SearchMapping)o;
        return Objects.equals(this.attribute, that.attribute) && Objects.equals(this.alias, that.alias) && Objects.equals(this.description, that.description) && Objects.equals((Object)this.field, (Object)that.field) && Objects.equals(this.exactMatch, that.exactMatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.alias, this.description, this.field, this.exactMatch});
    }

    public String toString() {
        return "SearchMapping{attribute='" + this.attribute + '\'' + ", alias='" + this.alias + '\'' + ", description='" + this.description + '\'' + ", field='" + (Object)((Object)this.field) + '\'' + ", exactMatch='" + this.exactMatch + '\'' + '}';
    }
}

