/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.replication;

import java.util.Objects;
import org.sonatype.nexus.repository.replication.BlobEventType;

public class BlobEvent {
    private String blobId;
    private String assetPath;
    private String repositoryName;
    private String replicationConnectionId;
    private BlobEventType blobEventType;
    private boolean inUse;
    private int retryCount = 0;

    public void retry() {
        ++this.retryCount;
    }

    public boolean shouldRetry() {
        return this.retryCount > 0;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getReplicationConnectionId() {
        return this.replicationConnectionId;
    }

    public BlobEventType getBlobEventType() {
        return this.blobEventType;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public BlobEvent withBlobId(String blobId) {
        this.blobId = blobId;
        return this;
    }

    public BlobEvent withAssetPath(String assetPath) {
        this.assetPath = assetPath;
        return this;
    }

    public BlobEvent withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public BlobEvent withReplicationConnectionId(String replicationConnectionId) {
        this.replicationConnectionId = replicationConnectionId;
        return this;
    }

    public BlobEvent withBlobEventType(BlobEventType blobEventType) {
        this.blobEventType = blobEventType;
        return this;
    }

    public BlobEvent withInUse(boolean inUse) {
        this.inUse = inUse;
        return this;
    }

    public BlobEvent withRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobEvent blobEvent = (BlobEvent)o;
        return this.inUse == blobEvent.inUse && this.retryCount == blobEvent.retryCount && Objects.equals(this.blobId, blobEvent.blobId) && Objects.equals(this.assetPath, blobEvent.assetPath) && Objects.equals(this.repositoryName, blobEvent.repositoryName) && Objects.equals(this.replicationConnectionId, blobEvent.replicationConnectionId) && this.blobEventType == blobEvent.blobEventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blobId, this.assetPath, this.repositoryName, this.replicationConnectionId, this.blobEventType, this.inUse, this.retryCount});
    }

    public String toString() {
        return "BlobEvent{blobId='" + this.blobId + '\'' + ", assetPath='" + this.assetPath + '\'' + ", repositoryName='" + this.repositoryName + '\'' + ", replicationConnectionId='" + this.replicationConnectionId + '\'' + ", blobEventType=" + (Object)((Object)this.blobEventType) + ", inUse=" + this.inUse + ", retryCount=" + this.retryCount + '}';
    }
}

