/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.query;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonatype.nexus.repository.query.QueryOptions;

public class PageResult<T> {
    private long total;
    private List<T> results;

    public PageResult(long total, List<T> results) {
        this.total = total;
        this.results = (List)Preconditions.checkNotNull(results);
    }

    public PageResult(QueryOptions queryOptions, List<T> results) {
        this(PageResult.estimateCount(queryOptions, results), results);
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getResults() {
        return this.results;
    }

    private static long estimateCount(QueryOptions queryOptions, List<?> items) {
        long count = items.size();
        if (queryOptions.getStart() != null && queryOptions.getLimit() != null) {
            count += (long)queryOptions.getStart().intValue();
            if (items.size() == queryOptions.getLimit().intValue()) {
                count += (long)queryOptions.getLimit().intValue();
            }
        }
        return count;
    }
}

