/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.ossindex;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.repository.ossindex.PackageUrlMapping;
import org.sonatype.nexus.repository.ossindex.PackageUrlService;

@Named
@Singleton
public class PackageUrlServiceImpl
extends ComponentSupport
implements PackageUrlService {
    private final Map<String, PackageUrlMapping> packageUrlMappings;

    @Inject
    public PackageUrlServiceImpl(Map<String, PackageUrlMapping> packageUrlMappings) {
        this.packageUrlMappings = (Map)Preconditions.checkNotNull(packageUrlMappings);
    }

    @Override
    public Optional<PackageUrl> getPackageUrl(String format, String namespace, String name, String version) {
        PackageUrlMapping mapping = this.packageUrlMappings.get(format);
        if (mapping != null) {
            try {
                return mapping.buildPackageUrl(namespace, name, version);
            }
            catch (Exception e) {
                this.log.debug("Cannot determine package URL coordinates for {} namespace/name/version {}/{}/{}", new Object[]{format, namespace, name, version, e});
            }
        }
        return Optional.empty();
    }
}

