/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.stateguard.StateGuardAware;
import org.sonatype.nexus.common.stateguard.Transitions;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.MissingFacetException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryDestroyedEvent;
import org.sonatype.nexus.repository.RepositoryStartedEvent;
import org.sonatype.nexus.repository.RepositoryStoppedEvent;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.internal.FacetLookup;

public class RepositoryImpl
extends ComponentSupport
implements Repository,
StateGuardAware {
    private static final long LOCK_TIMEOUT = 60L;
    private final EventManager eventManager;
    private final Type type;
    private final Format format;
    private final FacetLookup facets = new FacetLookup();
    private Configuration configuration;
    private String name;
    private final StateGuard states = new StateGuard.Builder().logger(this.createLogger()).initial("NEW").failure("FAILED").create();

    @Inject
    public RepositoryImpl(EventManager eventManager, @Assisted Type type, @Assisted Format format) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.type = (Type)Preconditions.checkNotNull((Object)type);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    public Type getType() {
        return this.type;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getName() {
        return (String)Preconditions.checkNotNull((Object)this.name);
    }

    public Configuration getConfiguration() {
        return (Configuration)Preconditions.checkNotNull((Object)this.configuration);
    }

    public boolean isStarted() {
        return this.states.is("STARTED");
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "type=" + this.type + ", format=" + this.format + ", name='" + this.name + '\'' + '}';
    }

    @Nonnull
    public StateGuard getStateGuard() {
        return this.states;
    }

    public void validate(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        HashSet violations = new HashSet();
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets) {
            this.log.debug("Validating facet: {}", (Object)facet);
            try {
                facet.validate(configuration);
            }
            catch (ConstraintViolationException e) {
                this.log.debug("Facet validation produced violations: {}", (Object)facet, (Object)e);
                violations.addAll(e.getConstraintViolations());
            }
            catch (Throwable t) {
                this.log.error("Failed to validate facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to validate facets");
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Transitions(from={"NEW"}, to="INITIALISED")
    public void init(Configuration configuration) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.name = configuration.getRepositoryName();
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets) {
            try {
                this.log.debug("Initializing facet: {}", (Object)facet);
                facet.init();
            }
            catch (Throwable t) {
                this.log.error("Failed to initialize facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to initialize facets");
    }

    @Guarded(by={"STOPPED"})
    public void update(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        this.validate(configuration);
        this.configuration = configuration;
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets) {
            try {
                this.log.debug("Updating facet: {}", (Object)facet);
                facet.update();
            }
            catch (Throwable t) {
                this.log.error("Failed to update facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to update facets");
    }

    @Transitions(from={"INITIALISED", "STOPPED"}, to="STARTED")
    public void start() throws Exception {
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets) {
            try {
                this.log.debug("Starting facet: {}", (Object)facet);
                facet.start();
            }
            catch (Throwable t) {
                this.log.error("Failed to start facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to start facets");
        this.eventManager.post((Object)new RepositoryStartedEvent((Repository)this));
    }

    public Lock getWriteLock() {
        return this.states.getWriteLock();
    }

    /*
     * Unable to fully structure code
     */
    public void stopSafe() throws Exception {
        failures = new MultipleFailures();
        repositoryLock = this.getWriteLock();
        facetLocks = new ArrayList<Lock>();
        if (repositoryLock.tryLock(60L, TimeUnit.SECONDS)) {
            try {
                for (Facet facet : this.facets.reverse()) {
                    facetLock = facet.getWriteLock();
                    if (facetLock.tryLock(60L, TimeUnit.SECONDS)) {
                        facetLocks.add(facetLock);
                        continue;
                    }
                    this.log.error("Failed to lock facet: {}", (Object)facet);
                    failures.add((Throwable)new RuntimeException(String.format("Failed to lock facet: %s", new Object[]{facet})));
                }
                failures.maybePropagate("Failed to lock facets");
                this.stop();
            }
            finally {
                ** for (facetLock : facetLocks)
            }
lbl-1000:
            // 1 sources

            {
                facetLock.unlock();
                continue;
            }
lbl22:
            // 1 sources

            repositoryLock.unlock();
        }
    }

    @Transitions(from={"STARTED"}, to="STOPPED", requiresWriteLock=false)
    public void stop() throws Exception {
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets.reverse()) {
            try {
                this.log.debug("Stopping facet: {}", (Object)facet);
                facet.stop();
            }
            catch (Throwable t) {
                this.log.error("Failed to stop facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to stop facets");
        this.eventManager.post((Object)new RepositoryStoppedEvent((Repository)this));
    }

    @Transitions(from={"STOPPED"}, to="DELETED")
    public void delete() throws Exception {
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets.reverse()) {
            try {
                this.log.debug("Deleting facet: {}", (Object)facet);
                facet.delete();
            }
            catch (Throwable t) {
                this.log.error("Failed to delete facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to delete facets");
    }

    @Transitions(to="DESTROYED")
    public void destroy() throws Exception {
        if (this.states.is("STARTED")) {
            this.stopSafe();
        }
        MultipleFailures failures = new MultipleFailures();
        for (Facet facet : this.facets.reverse()) {
            try {
                this.log.debug("Destroying facet: {}", (Object)facet);
                facet.destroy();
            }
            catch (Throwable t) {
                this.log.error("Failed to destroy facet: {}", (Object)facet, (Object)t);
                failures.add(t);
            }
        }
        failures.maybePropagate("Failed to destroy facets");
        this.facets.clear();
        this.configuration = null;
        this.eventManager.post((Object)new RepositoryDestroyedEvent((Repository)this));
    }

    @Guarded(by={"NEW"})
    public void attach(Facet facet) throws Exception {
        Preconditions.checkNotNull((Object)facet);
        this.log.debug("Attaching facet: {}", (Object)facet);
        facet.attach((Repository)this);
        this.facets.add(facet);
    }

    @Nonnull
    public <T extends Facet> T facet(Class<T> type) throws MissingFacetException {
        T facet = this.facets.get(type);
        if (facet == null) {
            throw new MissingFacetException((Repository)this, type);
        }
        return facet;
    }

    @Nonnull
    public <T extends Facet> Optional<T> optionalFacet(Class<T> type) {
        return Optional.ofNullable(this.facets.get(type));
    }

    public String getUrl() {
        return String.valueOf(BaseUrlHolder.get()) + "/repository/" + this.getName();
    }

    static final class State {
        public static final String NEW = "NEW";
        public static final String INITIALISED = "INITIALISED";
        public static final String STARTED = "STARTED";
        public static final String STOPPED = "STOPPED";
        public static final String DELETED = "DELETED";
        public static final String DESTROYED = "DESTROYED";
        public static final String FAILED = "FAILED";

        State() {
        }
    }
}

