/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryCacheInvalidationEvent;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryDestroyedEvent;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.RepositoryStartedEvent;
import org.sonatype.nexus.repository.RepositoryStoppedEvent;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusEvent;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryRestoredEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.rest.api.ApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;

@Named
@Singleton
public class RepositoryAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository";
    private ObjectMapper mapper = new ObjectMapper();
    private final Map<String, ApiRepositoryAdapter> convertersByFormat;
    private final ApiRepositoryAdapter defaultAdapter;

    @Inject
    public RepositoryAuditor(Map<String, ApiRepositoryAdapter> convertersByFormat, @Named(value="default") @Named(value="default") ApiRepositoryAdapter defaultAdapter) {
        this.convertersByFormat = convertersByFormat;
        this.defaultAdapter = defaultAdapter;
        this.registerType(RepositoryCacheInvalidationEvent.class, "cacheInvalidated");
        this.registerType(RepositoryCreatedEvent.class, "created");
        this.registerType(RepositoryRestoredEvent.class, "restored");
        this.registerType(RepositoryUpdatedEvent.class, "updated");
        this.registerType(RepositoryDestroyedEvent.class, "destroyed");
        this.registerType(RepositoryDeletedEvent.class, "deleted");
        this.registerType(RepositoryLoadedEvent.class, "loaded");
        this.registerType(RepositoryStartedEvent.class, "started");
        this.registerType(RepositoryStoppedEvent.class, "stopped");
        this.registerType(RemoteConnectionStatusEvent.class, "autoBlockStatus");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        if (this.isRecording()) {
            Repository repository = event.getRepository();
            AuditData data = this.getAuditData(repository.getName());
            data.setType(this.type(event.getClass()));
            if (event instanceof RepositoryCreatedEvent || event instanceof RepositoryUpdatedEvent) {
                data.setAttributes(this.createFullAttributes(repository));
            } else {
                Map<String, Object> attributes = this.createSimple(repository);
                if (event instanceof RemoteConnectionStatusEvent) {
                    attributes.put("statusType", ((RemoteConnectionStatusEvent)event).getStatus().getType());
                }
                data.setAttributes(attributes);
            }
            this.record(data);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryCacheInvalidationEvent event) {
        if (this.isRecording()) {
            AuditData data = this.getAuditData(event.getRepositoryName());
            data.setType(this.type(event.getClass()));
            this.record(data);
        }
    }

    private AuditData getAuditData(String repositoryName) {
        AuditData data = new AuditData();
        data.setDomain(DOMAIN);
        data.setContext(repositoryName);
        return data;
    }

    private Map<String, Object> createFullAttributes(Repository repository) {
        boolean baseUrlAbsent = !BaseUrlHolder.isSet();
        try {
            if (baseUrlAbsent) {
                BaseUrlHolder.set((String)"", (String)"");
            }
            AbstractApiRepository apiObject = this.convert(repository);
            ObjectWriter writer = this.mapper.writerFor(apiObject.getClass());
            String json = writer.writeValueAsString((Object)apiObject);
            Map map = (Map)this.mapper.readerFor((TypeReference)new TypeReference<Map<String, Object>>(){}).readValue(json);
            return map;
        }
        catch (Exception e) {
            this.log.error("Failed to convert repo object falling back to simple", (Throwable)e);
            Map<String, Object> map = this.createSimple(repository);
            return map;
        }
        finally {
            if (baseUrlAbsent) {
                BaseUrlHolder.unset();
            }
        }
    }

    private Map<String, Object> createSimple(Repository repository) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", repository.getName());
        attributes.put("type", repository.getType().getValue());
        attributes.put("format", repository.getFormat().getValue());
        return attributes;
    }

    private AbstractApiRepository convert(Repository repository) {
        return this.convertersByFormat.getOrDefault(repository.getFormat().getValue(), this.defaultAdapter).adapt(repository);
    }
}

