/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class UntypedObjectDeserializerSerializer
extends UntypedObjectDeserializer {
    protected final JsonGenerator generator;

    public UntypedObjectDeserializerSerializer(JsonGenerator generator) {
        super(null, null);
        this.generator = (JsonGenerator)Preconditions.checkNotNull((Object)generator);
    }

    @Nullable
    public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.defaultDeserialize(parser.getCurrentName(), parser, context);
    }

    @Nullable
    protected Object mapObject(JsonParser parser, DeserializationContext context) throws IOException {
        this.generator.writeStartObject();
        super.mapObject(parser, context);
        this.generator.writeEndObject();
        return null;
    }

    @Nullable
    protected Object mapArray(JsonParser parser, DeserializationContext context) throws IOException {
        this.generator.writeStartArray();
        super.mapArray(parser, context);
        this.generator.writeEndArray();
        return null;
    }

    protected final Object defaultDeserialize(String fieldName, JsonParser parser, DeserializationContext context) throws IOException {
        Object value;
        if (Objects.nonNull(fieldName)) {
            this.generator.writeFieldName(fieldName);
        }
        if (Objects.nonNull(value = this.defaultValueDeserialize(parser, context)) || parser.currentTokenId() == 11) {
            this.generator.writeObject(value);
        }
        return value;
    }

    protected final Object defaultValueDeserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return super.deserialize(parser, context);
    }
}

