/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.sonatype.nexus.repository.json.CurrentPathJsonParser;
import org.sonatype.nexus.repository.json.MapDeserializerSerializer;
import org.sonatype.nexus.repository.json.UntypedObjectDeserializerSerializer;

public class StreamingObjectMapper {
    private static final TypeReference<HashMap<String, Object>> RAW_MAP_JSON_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private final CustomStreamingObjectMapper objectMapper = new CustomStreamingObjectMapper();

    public StreamingObjectMapper configure(SerializationFeature feature, boolean state) {
        this.objectMapper.configure(feature, state);
        return this;
    }

    public StreamingObjectMapper disable(JsonGenerator.Feature ... feature) {
        this.objectMapper.disable(feature);
        return this;
    }

    public boolean isEnabled(SerializationFeature feature) {
        return this.objectMapper.isEnabled(feature);
    }

    public StreamingObjectMapper readAndWrite(InputStream input, OutputStream output) throws IOException {
        this.objectMapper.readAndWrite(input, output);
        return this;
    }

    protected void beforeDeserialize(JsonGenerator generator) throws IOException {
    }

    protected void deserializeAndSerialize(JsonParser parser, DeserializationContext context, MapDeserializer rootDeserializer, JsonGenerator generator) throws IOException {
        new MapDeserializerSerializer(rootDeserializer, new UntypedObjectDeserializerSerializer(generator)).deserialize(parser, context);
    }

    protected void afterDeserialize(JsonGenerator generator) throws IOException {
    }

    private class CustomStreamingObjectMapper
    extends ObjectMapper {
        private final JavaType valueType;
        private final JsonFactory jsonFactory;

        private CustomStreamingObjectMapper() {
            this.valueType = this._typeFactory.constructType(RAW_MAP_JSON_TYPE_REF);
            this.jsonFactory = new JsonFactory((ObjectCodec)this);
        }

        private void readAndWrite(InputStream input, OutputStream output) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CurrentPathJsonParser parser = new CurrentPathJsonParser(this._jsonFactory.createParser(input));){
                JsonToken token = this._initForReading(parser, this.valueType);
                DeserializationConfig config = this.getDeserializationConfig();
                DefaultDeserializationContext context = this.createDeserializationContext(parser, config);
                if (token != JsonToken.VALUE_NULL && token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT) {
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (JsonGenerator generator = this.jsonFactory.createGenerator(output);){
                        generator.writeStartObject();
                        StreamingObjectMapper.this.beforeDeserialize(generator);
                        JsonDeserializer rootDeserializer = this._findRootDeserializer((DeserializationContext)context, this.valueType);
                        StreamingObjectMapper.this.deserializeAndSerialize(parser, (DeserializationContext)context, (MapDeserializer)rootDeserializer, generator);
                        StreamingObjectMapper.this.afterDeserialize(generator);
                        context.checkUnresolvedObjectId();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(parser, (DeserializationContext)context, this.valueType);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }
}

