/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonParser;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.json.CurrentPathJsonParser;

public class NestedAttributesMapJsonParser
extends CurrentPathJsonParser {
    private final NestedAttributesMap root;
    private boolean mappingInsideArray;
    private boolean defaultMapping;

    public NestedAttributesMapJsonParser(JsonParser jsonParser, NestedAttributesMap root) {
        super((JsonParser)Preconditions.checkNotNull((Object)jsonParser));
        this.root = (NestedAttributesMap)Preconditions.checkNotNull((Object)root);
    }

    @Nullable
    public NestedAttributesMap getChildFromRoot() {
        if (this.isMappingInsideArray()) {
            return null;
        }
        NestedAttributesMap existingChild = this.root;
        String[] stringArray = this.currentPathInParts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            Object o = existingChild.get(part);
            if (Objects.isNull(o) || o instanceof Map) {
                existingChild = existingChild.child(part);
            }
            ++n2;
        }
        return existingChild.equals(this.root) ? null : existingChild;
    }

    public void markMappingInsideArray() {
        this.mappingInsideArray = true;
    }

    public void unMarkMappingInsideArray() {
        this.mappingInsideArray = false;
    }

    public void enableDefaultMapping() {
        this.defaultMapping = true;
    }

    public void disableDefaultMapping() {
        this.defaultMapping = false;
    }

    public NestedAttributesMap getRoot() {
        return this.root;
    }

    public boolean isMappingInsideArray() {
        return this.mappingInsideArray;
    }

    public boolean isDefaultMapping() {
        return this.defaultMapping;
    }
}

