/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.json;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.json.NestedAttributesMapJsonParser;
import org.sonatype.nexus.repository.json.NestedAttributesMapStdValueInstantiator;
import org.sonatype.nexus.repository.json.NestedAttributesMapUntypedObjectDeserializer;
import org.sonatype.nexus.repository.json.SourceMapDeserializer;

public class MergeObjectMapper {
    private static final TypeReference VALUE_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private final CustomerMergeObjectMapper objectMapper = new CustomerMergeObjectMapper();

    public NestedAttributesMap read(InputStream inputStream) throws IOException {
        return this.merge(Collections.singletonList(() -> inputStream), null);
    }

    public NestedAttributesMap read(InputStreamSupplier inputStreamSupplier) throws IOException {
        return this.merge(Collections.singletonList(inputStreamSupplier), null);
    }

    public NestedAttributesMap merge(List<InputStreamSupplier> inputStreams) throws IOException {
        return this.objectMapper.merge(inputStreams);
    }

    public NestedAttributesMap merge(List<InputStreamSupplier> inputStreams, @Nullable Charset charset) throws IOException {
        return this.objectMapper.merge(inputStreams, charset);
    }

    protected void merge(NestedAttributesMap result, InputStream inputStream, @Nullable Charset charset) throws IOException {
        this.objectMapper.merge(result, inputStream, charset);
    }

    protected void deserialize(NestedAttributesMapJsonParser parser, DeserializationContext context, MapDeserializer rootDeserializer) throws IOException {
        SourceMapDeserializer.of(rootDeserializer.getValueType(), (ValueInstantiator)new NestedAttributesMapStdValueInstantiator(parser.getRoot()), (JsonDeserializer<Object>)new NestedAttributesMapUntypedObjectDeserializer(parser)).deserialize(parser, context);
    }

    private class CustomerMergeObjectMapper
    extends ObjectMapper {
        private final JavaType valueType;

        private CustomerMergeObjectMapper() {
            this.valueType = this._typeFactory.constructType(VALUE_TYPE_REF);
        }

        private NestedAttributesMap merge(List<InputStreamSupplier> inputStreams) throws IOException {
            return this.merge(inputStreams, null);
        }

        private NestedAttributesMap merge(List<InputStreamSupplier> inputStreams, @Nullable Charset charset) throws IOException {
            NestedAttributesMap result = new NestedAttributesMap("mergeMap", (Map)Maps.newHashMap());
            for (InputStreamSupplier inputStreamSupplier : inputStreams) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream inputStream = inputStreamSupplier.get();){
                    this.merge(result, inputStream, charset);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return result;
        }

        private void merge(NestedAttributesMap result, InputStream inputStream, @Nullable Charset charset) throws IOException {
            Throwable throwable = null;
            Object var5_6 = null;
            try (NestedAttributesMapJsonParser parser = this.createParser(result, inputStream, charset);){
                JsonToken token = this._initForReading(parser, this.valueType);
                DeserializationConfig config = this.getDeserializationConfig();
                DefaultDeserializationContext context = this.createDeserializationContext(parser, config);
                if (token != JsonToken.VALUE_NULL && token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT) {
                    JsonDeserializer rootDeserializer = this._findRootDeserializer((DeserializationContext)context, this.valueType);
                    MergeObjectMapper.this.deserialize(parser, (DeserializationContext)context, (MapDeserializer)rootDeserializer);
                    context.checkUnresolvedObjectId();
                }
                if (config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(parser, (DeserializationContext)context, this.valueType);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private NestedAttributesMapJsonParser createParser(NestedAttributesMap result, InputStream inputStream, @Nullable Charset charset) throws IOException {
            if (Objects.nonNull(charset)) {
                InputStreamReader reader = new InputStreamReader(inputStream, charset);
                return new NestedAttributesMapJsonParser(this._jsonFactory.createParser((Reader)reader), result);
            }
            return new NestedAttributesMapJsonParser(this._jsonFactory.createParser(inputStream), result);
        }
    }
}

