/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.search.index.task;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.index.SearchUpdateService;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class SearchUpdateTaskManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private final boolean enabled;
    private final SearchUpdateService searchUpdateService;

    @Inject
    public SearchUpdateTaskManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager, SearchUpdateService searchUpdateService, @Named(value="${nexus.search.updateIndexesOnStartup.enabled:-true}") @Named(value="${nexus.search.updateIndexesOnStartup.enabled:-true}") boolean enabled) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.searchUpdateService = Objects.requireNonNull(searchUpdateService);
        this.enabled = enabled;
    }

    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        try {
            boolean existingTask;
            List<String> reindexList = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(this.searchUpdateService::needsReindex).map(Repository::getName).collect(Collectors.toList());
            if (!reindexList.isEmpty() && !(existingTask = this.taskScheduler.findAndSubmit("repository.search.update"))) {
                this.runSearchUpdateTaskForRepositories(reindexList);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to determine if any repository indexes needed to be updated", (Throwable)e);
        }
    }

    private void runSearchUpdateTaskForRepositories(List<String> repositories) {
        String repositoriesCsv = String.join((CharSequence)",", repositories);
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.search.update");
        configuration.setString("repositoryNames", repositoriesCsv);
        configuration.setName("Update repository indexes - (" + repositoriesCsv + ")");
        this.taskScheduler.submit(configuration);
    }
}

