/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;
import org.sonatype.nexus.security.config.memory.MemoryCPrivilege;

@Named
@Singleton
public class RepositoryViewSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String REPOSITORY_VIEW_ALL_PREFIX = "nx-repository-view-*-*-";
    public static final String REPOSITORY_VIEW_ALL_DESCRIPTION_SUFFIX = " permissions for all repository views";
    public static final String ACTION_BROWSE = "browse";
    public static final String ACTION_READ = "read";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege("*"));
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege(ACTION_BROWSE));
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege(ACTION_READ));
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege(ACTION_EDIT));
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege(ACTION_ADD));
        config.addPrivilege((CPrivilege)this.createRepositoryViewPrivilege(ACTION_DELETE));
        return config;
    }

    private MemoryCPrivilege createRepositoryViewPrivilege(String action) {
        String id = REPOSITORY_VIEW_ALL_PREFIX + action;
        String description = String.valueOf("*".equals(action) ? "All" : StringUtils.capitalize((String)action)) + REPOSITORY_VIEW_ALL_DESCRIPTION_SUFFIX;
        return new MemoryCPrivilege.MemoryCPrivilegeBuilder(id).type("repository-view").readOnly(true).name(id).description(description).property("format", "*").property("repository", "*").property("actions", action).build();
    }
}

