/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.importtask;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.sonatype.nexus.repository.Repository;

public class ImportFileConfiguration {
    private final Repository repository;
    private final File file;
    private final String assetName;
    private final boolean hardLinkingEnabled;

    public ImportFileConfiguration(Repository repository, File file, String assetName) {
        this(repository, file, assetName, false);
    }

    public ImportFileConfiguration(Repository repository, File file, String assetName, boolean hardLinkingEnabled) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.assetName = (String)Preconditions.checkNotNull((Object)assetName);
        this.hardLinkingEnabled = hardLinkingEnabled;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public File getFile() {
        return this.file;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public boolean isHardLinkingEnabled() {
        return this.hardLinkingEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportFileConfiguration that = (ImportFileConfiguration)o;
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.file, that.file) && Objects.equals(this.assetName, that.assetName) && this.hardLinkingEnabled == that.hardLinkingEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.repository, this.file, this.assetName, this.hardLinkingEnabled);
    }
}

