/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

public abstract class MergingGroupHandlerSupport
extends GroupHandler {
    private final HashFunction etagDigester = Hashing.sha256();
    private Cooperation2 cooperation;

    protected void configureCooperation(Cooperation2Factory cooperationFactory, boolean cooperationEnabled, Duration majorTimeout, Duration minorTimeout, int threadsPerKey) {
        this.cooperation = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey).build(((Object)((Object)this)).getClass(), new String[0]);
    }

    @Override
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Map successfulResponses;
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        Headers headers = context.getRequest().getHeaders();
        String rangeheader = headers.get("Range");
        headers.remove("Range");
        try {
            LinkedHashMap<Repository, Response> responses = this.getAll(context, groupFacet.members(), dispatched);
            successfulResponses = responses.entrySet().stream().filter(entry -> ((Response)entry.getValue()).getStatus().getCode() == 200).filter(entry -> ((Response)entry.getValue()).getPayload() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, MergingGroupHandlerSupport.throwingMerger(), LinkedHashMap::new));
        }
        catch (Throwable throwable) {
            headers.set("Range", new String[]{rangeheader});
            throw throwable;
        }
        headers.set("Range", new String[]{rangeheader});
        if (successfulResponses.isEmpty()) {
            return this.getCached(context).map(HttpResponses::ok).orElse(this.notFoundResponse(context));
        }
        if (successfulResponses.size() == 1 && this.shouldReturnOnlyRespondingMember(context.getRepository())) {
            return (Response)Iterables.getOnlyElement(successfulResponses.values());
        }
        return this.merge(context, successfulResponses).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    private Optional<Content> merge(Context context, Map<Repository, Response> successfulResponses) throws IOException {
        Optional<String> optEtag = this.computeEtag(successfulResponses.values());
        Optional<Content> existing = this.getCached(context).filter(this.unchanged(optEtag));
        if (existing.isPresent()) {
            return existing;
        }
        return (Optional)this.cooperation.on(() -> this.merge(context, successfulResponses, optEtag)).checkFunction(() -> Optional.of(this.getCached(context))).cooperate(context.getRepository().getName(), this.cooperationKey(context));
    }

    protected abstract String[] cooperationKey(Context var1);

    protected abstract Optional<Content> merge(Context var1, Map<Repository, Response> var2, Optional<String> var3) throws IOException;

    protected abstract Optional<Content> getCached(Context var1);

    private Optional<String> computeEtag(Collection<Response> successfulResponses) {
        Hasher etagDigest = this.etagDigester.newHasher();
        AtomicBoolean valid = new AtomicBoolean(true);
        successfulResponses.stream().map(Response::getPayload).map(MergingGroupHandlerSupport::etag).peek(optEtag -> {
            boolean bl = valid.compareAndSet(true, optEtag.isPresent());
        }).filter(Optional::isPresent).map(Optional::get).forEach(etag -> {
            Hasher hasher2 = etagDigest.putString((CharSequence)etag, StandardCharsets.UTF_8);
        });
        if (valid.get()) {
            return Optional.of(etagDigest.hash().toString());
        }
        this.log.warn("Missing etag on response from member repository when computing metadata");
        return Optional.empty();
    }

    private static Optional<String> etag(Payload payload) {
        if (!(payload instanceof Content)) {
            return Optional.empty();
        }
        AttributesMap attributes = ((Content)payload).getAttributes();
        CacheInfo cacheInfo = (CacheInfo)attributes.get(CacheInfo.class);
        if (cacheInfo != null && cacheInfo.getCacheToken() != null) {
            if (cacheInfo.getCacheToken() != null) {
                return Optional.of(cacheInfo.getCacheToken());
            }
            return Optional.of(ISODateTimeFormat.dateTime().print((ReadableInstant)cacheInfo.getLastVerified()));
        }
        String etag = (String)attributes.get("etag", String.class);
        if (etag != null) {
            return Optional.of(etag);
        }
        return Optional.empty();
    }

    private Predicate<Content> unchanged(Optional<String> etag) {
        if (!etag.isPresent()) {
            return __ -> false;
        }
        return content -> Optional.ofNullable(content.getAttributes().get("etag")).map(((String)etag.get())::equals).orElse(false);
    }

    protected static Predicate<String> skipUntil(Predicate<String> matcher) {
        boolean[] done = new boolean[1];
        return line -> {
            if (done[0]) {
                return true;
            }
            blArray[0] = matcher.test((String)line);
            return false;
        };
    }

    protected boolean shouldReturnOnlyRespondingMember(Repository repository) {
        return true;
    }

    protected static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

