/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.db.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.sql.Connection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.db.DatabaseCheck;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeEventSupport;

@Named
@Singleton
@FeatureFlag(name="nexus.datastore.enabled")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class DatabaseCheckImpl
extends StateGuardLifecycleSupport
implements DatabaseCheck,
EventAware {
    private final DataStoreManager dataStoreManager;
    private final boolean datastoreClustered;
    private DataSource dataSource;
    private MigrationVersion currentSchemaVersion;
    private boolean postgresql = false;

    @Inject
    public DatabaseCheckImpl(DataStoreManager dataStoreManager, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean datastoreClustered) {
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
        this.datastoreClustered = datastoreClustered;
    }

    protected void doStart() throws Exception {
        this.dataSource = ((DataStore)this.dataStoreManager.get("nexus").orElseThrow(() -> new IllegalStateException("Missing DataStore named: nexus"))).getDataSource();
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection con = this.dataSource.getConnection();){
            this.postgresql = "PostgreSQL".equalsIgnoreCase(con.getMetaData().getDatabaseProductName());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public boolean isPostgresql() {
        return this.postgresql;
    }

    public boolean isAllowedByVersion(Class<?> annotatedClass) {
        if (!this.datastoreClustered) {
            return true;
        }
        AvailabilityVersion availabilityVersion = annotatedClass.getAnnotation(AvailabilityVersion.class);
        if (availabilityVersion != null && this.isAllowed(availabilityVersion.from())) {
            return true;
        }
        if (availabilityVersion == null) {
            this.log.error("Missing database version specified for {}", annotatedClass);
        }
        this.log.debug("The database schema version is lower than the minimum required to enable {}", annotatedClass);
        return false;
    }

    @Subscribe
    public void on(UpgradeEventSupport event) {
        Optional<MigrationVersion> schemaVersion = event.getSchemaVersion().map(MigrationVersion::fromVersion);
        if (schemaVersion.isPresent()) {
            this.currentSchemaVersion = schemaVersion.get();
        }
    }

    private boolean isAllowed(String requiredVersion) {
        if (this.currentSchemaVersion == null) {
            this.currentSchemaVersion = this.getMigrationVersion(this.dataSource);
            if (this.currentSchemaVersion == null) {
                return true;
            }
        }
        return this.currentSchemaVersion.isAtLeast(requiredVersion);
    }

    @VisibleForTesting
    MigrationVersion getMigrationVersion(DataSource dataSource) {
        if (dataSource == null) {
            this.log.warn("datasource has not been initialised");
            return null;
        }
        Flyway flyway = Flyway.configure().dataSource(dataSource).load();
        MigrationInfo current = flyway.info().current();
        if (current != null) {
            return current.getVersion();
        }
        this.log.error("Could not determine database schema version");
        return null;
    }
}

