/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.capability;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.repository.capability.GlobalRepositorySettings;
import org.sonatype.nexus.repository.capability.StorageSettingsCapabilityConfiguration;

@Named(value="StorageSettings")
public class StorageSettingsCapability
extends CapabilitySupport<StorageSettingsCapabilityConfiguration> {
    private final GlobalRepositorySettings globalSettings;

    @Inject
    public StorageSettingsCapability(GlobalRepositorySettings globalSettings) {
        this.globalSettings = (GlobalRepositorySettings)((Object)Preconditions.checkNotNull((Object)((Object)globalSettings)));
    }

    protected StorageSettingsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new StorageSettingsCapabilityConfiguration(properties);
    }

    protected void onUpdate(StorageSettingsCapabilityConfiguration config) throws Exception {
        if (this.context().isActive()) {
            this.configureDownloadedInterval(config);
        }
    }

    protected void onActivate(StorageSettingsCapabilityConfiguration config) throws Exception {
        this.configureDownloadedInterval(config);
    }

    protected void onPassivate(StorageSettingsCapabilityConfiguration config) throws Exception {
        this.resetDownloadedInterval();
    }

    private void configureDownloadedInterval(StorageSettingsCapabilityConfiguration config) {
        this.log.info("Using configured value of {} hours for LastDownloaded interval", (Object)config.getLastDownloadedInterval());
        this.globalSettings.setLastDownloadedInterval(this.parseAsHours(config.getLastDownloadedInterval()));
    }

    private void resetDownloadedInterval() {
        this.log.info("Reverting back to {} hours for LastDownloaded interval", (Object)GlobalRepositorySettings.DEFAULT_LAST_DOWNLOADED_INTERVAL.toHours());
        this.globalSettings.setLastDownloadedInterval(GlobalRepositorySettings.DEFAULT_LAST_DOWNLOADED_INTERVAL);
    }

    private Duration parseAsHours(String hours) {
        return Duration.ofHours(Long.parseLong(hours));
    }
}

