/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryCacheInvalidationEvent;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.proxy.ProxyFacet;

@Named
@Singleton
public class RepositoryCacheInvalidationService
implements EventAware {
    private final RepositoryManager repositoryManager;
    private final EventManager eventManager;

    @Inject
    public RepositoryCacheInvalidationService(RepositoryManager repositoryManager, EventManager eventManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public void processCachesInvalidation(Repository repository) {
        this.invalidateCaches(repository, true);
    }

    private void invalidateCaches(Repository repository, boolean isTriggeredByCurrentNode) {
        Preconditions.checkNotNull((Object)repository);
        if ("group".equals(repository.getType().getValue())) {
            RepositoryCacheInvalidationService.invalidateGroupCaches(repository);
        } else if ("proxy".equals(repository.getType().getValue())) {
            RepositoryCacheInvalidationService.invalidateProxyAndNegativeCaches(repository);
        }
        if (isTriggeredByCurrentNode) {
            this.postEvent(repository);
        }
    }

    private static void invalidateGroupCaches(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"group".equals(repository.getType().getValue()));
        GroupFacet groupFacet = (GroupFacet)repository.facet(GroupFacet.class);
        groupFacet.invalidateGroupCaches();
    }

    private static void invalidateProxyAndNegativeCaches(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"proxy".equals(repository.getType().getValue()));
        ProxyFacet proxyFacet = (ProxyFacet)repository.facet(ProxyFacet.class);
        proxyFacet.invalidateProxyCaches();
        NegativeCacheFacet negativeCacheFacet = (NegativeCacheFacet)repository.facet(NegativeCacheFacet.class);
        negativeCacheFacet.invalidate();
    }

    private void postEvent(Repository repository) {
        if (!EventHelper.isReplicating()) {
            this.eventManager.post((Object)new RepositoryCacheInvalidationEvent(repository.getName()));
        }
    }

    @Subscribe
    public void on(RepositoryCacheInvalidationEvent event) {
        this.invalidateCaches(this.repositoryManager.get(event.getRepositoryName()), false);
    }
}

