/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.cache;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheKey;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatus;
import org.sonatype.nexus.repository.httpclient.RemoteConnectionStatusType;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

public class NegativeCacheHandler
extends ComponentSupport
implements Handler {
    private static final Set<String> NFC_CACHEABLE_ACTIONS = ImmutableSet.of((Object)"GET", (Object)"HEAD");

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response;
        String action = context.getRequest().getAction();
        if (!NFC_CACHEABLE_ACTIONS.contains(action)) {
            return context.proceed();
        }
        NegativeCacheFacet negativeCache = (NegativeCacheFacet)context.getRepository().facet(NegativeCacheFacet.class);
        NegativeCacheKey key = negativeCache.getCacheKey(context);
        this.log.debug("Handling NotFoundCache for {}", (Object)key);
        if (context.getAttributes() != null && Boolean.TRUE.equals(context.getAttributes().get("IS_REPLICATION_REQUEST", Boolean.class, (Object)false))) {
            this.log.debug("Skipping NotFoundCache for {} as this is a replication request.", (Object)key);
            Response response2 = context.proceed();
            if (response2.getStatus().isSuccessful()) {
                negativeCache.invalidate(key);
            }
            return response2;
        }
        Status status = negativeCache.get(key);
        if (status == null) {
            response = context.proceed();
            if (this.isNotFound(response) && !this.isRemoteBlocked(context)) {
                negativeCache.put(key, response.getStatus());
                this.log.debug("Couldn't find {} - adding to NFC", (Object)key);
            } else if (response.getStatus().isSuccessful()) {
                negativeCache.invalidate(key);
                this.log.debug("Found {} - invalidating NFC", (Object)key);
            }
        } else {
            response = this.buildResponse(status, context);
            this.log.debug("Found {} in negative cache, returning {}", (Object)key, (Object)response);
        }
        return response;
    }

    protected Response buildResponse(Status status, Context context) {
        return new Response.Builder().status(status).build();
    }

    private boolean isNotFound(Response response) {
        return 404 == response.getStatus().getCode();
    }

    private boolean isRemoteBlocked(Context context) {
        RemoteConnectionStatus remoteConnectionStatus = ((HttpClientFacet)context.getRepository().facet(HttpClientFacet.class)).getStatus();
        return remoteConnectionStatus.getType() == RemoteConnectionStatusType.AUTO_BLOCKED_UNAVAILABLE || remoteConnectionStatus.getType() == RemoteConnectionStatusType.BLOCKED;
    }
}

