/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.node;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.browse.node.RebuildBrowseNodeFailedException;
import org.sonatype.nexus.repository.browse.node.RebuildBrowseNodeService;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.spi.TaskResultStateStore;

@Named
public class RebuildBrowseNodesTask
extends RepositoryTaskSupport
implements Cancelable {
    private static final String PYPI_FORMAT_NAME = "pypi";
    private final RebuildBrowseNodeService rebuildBrowseNodeService;
    private final TaskResultStateStore taskResultStateStore;

    @Inject
    public RebuildBrowseNodesTask(RebuildBrowseNodeService rebuildBrowseNodeService, TaskResultStateStore taskResultStateStore) {
        this.rebuildBrowseNodeService = (RebuildBrowseNodeService)Preconditions.checkNotNull((Object)rebuildBrowseNodeService);
        this.taskResultStateStore = (TaskResultStateStore)Preconditions.checkNotNull((Object)taskResultStateStore);
    }

    public String getMessage() {
        return "Rebuilding browse tree for " + this.getRepositoryField();
    }

    protected void execute(Repository repo) {
        try {
            this.updateProgress(this.taskResultStateStore, null);
            this.delayIfPyPi(repo);
            this.rebuildBrowseNodeService.rebuild(repo, progressMessage -> this.updateProgress(this.taskResultStateStore, (String)progressMessage));
        }
        catch (RebuildBrowseNodeFailedException e) {
            this.log.error("Error rebuilding browse nodes for repository: {}", (Object)repo, (Object)e);
        }
    }

    private void delayIfPyPi(Repository repo) {
        if (PYPI_FORMAT_NAME.equals(repo.getFormat().getValue()) && "proxy".equals(repo.getType().getValue())) {
            try {
                this.log.info("Delaying rebuild browse node task for repository {} for 30 seconds", (Object)repo);
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                this.log.warn("Problem delaying rebuild for PyPI repository: {}", (Object)e.getMessage());
            }
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository != null;
    }
}

