/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.browse.node.BrowsePath;

public class BrowsePathBuilder {
    private BrowsePathBuilder() {
    }

    public static List<BrowsePath> fromPaths(List<String> paths, boolean trailingSlash) {
        ArrayList<BrowsePath> results = new ArrayList<BrowsePath>();
        StringBuilder requestPath = new StringBuilder().append('/');
        int i = 0;
        while (i < paths.size()) {
            requestPath.append(paths.get(i));
            if (trailingSlash || i < paths.size() - 1) {
                requestPath.append('/');
            }
            results.add(new BrowsePath(paths.get(i), requestPath.toString()));
            ++i;
        }
        return results;
    }

    public static void appendPath(List<BrowsePath> browsePaths, String path) {
        BrowsePathBuilder.appendPath(browsePaths, path, BrowsePathBuilder.combine(BrowsePathBuilder.getLastRequestPath(browsePaths), path));
    }

    private static String combine(String browsePath, String path) {
        return String.valueOf(StringUtils.appendIfMissing((String)browsePath, (CharSequence)"/", (CharSequence[])new CharSequence[0])) + StringUtils.removeStart((String)path, (String)"/");
    }

    private static String getLastRequestPath(List<BrowsePath> browsePaths) {
        return browsePaths.isEmpty() ? "" : BrowsePathBuilder.last(browsePaths).getRequestPath();
    }

    public static <T> T last(List<T> items) {
        return items.get(items.size() - 1);
    }

    public static void appendPath(List<BrowsePath> browsePaths, String path, String requestPath) {
        browsePaths.add(new BrowsePath(path, requestPath));
    }
}

