/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.servlet;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.servlet.FilterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.common.util.KeycloakUriBuilder;

public class FilterSamlSessionStore
extends FilterSessionStore
implements SamlSessionStore {
    protected static Logger log = Logger.getLogger(SamlSessionStore.class);
    protected final SessionIdMapper idMapper;
    private final SamlDeployment deployment;

    public FilterSamlSessionStore(HttpServletRequest request, HttpFacade facade, int maxBuffer, SessionIdMapper idMapper, SamlDeployment deployment) {
        super(request, facade, maxBuffer);
        this.idMapper = idMapper;
        this.deployment = deployment;
    }

    public void setCurrentAction(SamlSessionStore.CurrentAction action) {
        if (action == SamlSessionStore.CurrentAction.NONE && this.request.getSession(false) == null) {
            return;
        }
        this.request.getSession().setAttribute("SAML_CURRENT_ACTION", (Object)action);
    }

    public boolean isLoggingIn() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_IN;
    }

    public boolean isLoggingOut() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_OUT;
    }

    public void logoutAccount() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return;
        }
        if (session != null) {
            SamlSession samlSession;
            if (this.idMapper != null) {
                this.idMapper.removeSession(session.getId());
            }
            if ((samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName())) != null) {
                session.removeAttribute(SamlSession.class.getName());
            }
            this.clearSavedRequest(session);
        }
    }

    public void logoutByPrincipal(String principal) {
        Set sessions;
        SamlSession account = this.getAccount();
        if (account != null && account.getPrincipal().getSamlSubject().equals(principal)) {
            this.logoutAccount();
        }
        if (this.idMapper != null && (sessions = this.idMapper.getUserSessions(principal)) != null) {
            LinkedList ids = new LinkedList();
            ids.addAll(sessions);
            for (String id : ids) {
                this.idMapper.removeSession(id);
            }
        }
    }

    public void logoutBySsoId(List<String> ssoIds) {
        SamlSession account = this.getAccount();
        for (String ssoId : ssoIds) {
            if (account != null && account.getSessionIndex().equals(ssoId)) {
                this.logoutAccount();
                continue;
            }
            if (this.idMapper == null) continue;
            String sessionId = this.idMapper.getSessionFromSSO(ssoId);
            this.idMapper.removeSession(sessionId);
        }
    }

    public boolean isLoggedIn() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            log.debug((Object)"session was null, returning false");
            return false;
        }
        SamlSession samlSession = SamlUtil.validateSamlSession((Object)session.getAttribute(SamlSession.class.getName()), (SamlDeployment)this.deployment);
        if (samlSession == null) {
            log.debug((Object)"SamlSession was not in session, returning null");
            return false;
        }
        if (this.idMapper != null && !this.idMapper.hasSession(session.getId())) {
            this.logoutAccount();
            return false;
        }
        this.needRequestRestore = this.restoreRequest();
        return true;
    }

    public HttpServletRequestWrapper getWrap() {
        SamlSession samlSession;
        HttpSession session = this.request.getSession(true);
        SamlSession account = samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
        return this.buildWrapper(session, (KeycloakAccount)account);
    }

    public void saveAccount(SamlSession account) {
        HttpSession session = this.request.getSession(true);
        session.setAttribute(SamlSession.class.getName(), (Object)account);
        if (this.idMapper != null) {
            this.idMapper.map(account.getSessionIndex(), account.getPrincipal().getSamlSubject(), session.getId());
        }
    }

    public SamlSession getAccount() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        return (SamlSession)session.getAttribute(SamlSession.class.getName());
    }

    public String getRedirectUri() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        String redirect = (String)session.getAttribute("__REDIRECT_URI");
        if (redirect == null) {
            String contextPath = this.request.getContextPath();
            String baseUri = KeycloakUriBuilder.fromUri((String)this.request.getRequestURL().toString()).replacePath(contextPath).build(new Object[0]).toString();
            return SamlUtil.getRedirectTo((HttpFacade)this.facade, (String)contextPath, (String)baseUri);
        }
        return redirect;
    }
}

