/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.spi;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskState;

public class TaskResultState {
    private final String taskId;
    private final TaskState state;
    private final LastRunState lastRunState;
    private final Date nextFireTime;
    private final String progress;

    public TaskResultState(String taskId, TaskState state, @Nullable Date nextFireTime, @Nullable LastRunState lastRunState, @Nullable String progress) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId);
        this.state = (TaskState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.nextFireTime = nextFireTime;
        this.lastRunState = lastRunState;
        this.progress = progress;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Optional<LastRunState> getLastRunState() {
        return Optional.ofNullable(this.lastRunState);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskState getState() {
        return this.state;
    }

    @Nullable
    public TaskState getLastEndState() {
        return this.getLastRunState().map(LastRunState::getEndState).orElse(null);
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.getLastRunState().map(LastRunState::getRunStarted).orElse(null);
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.getLastRunState().map(LastRunState::getRunDuration).orElse(null);
    }

    @Nullable
    public String getProgress() {
        return this.progress;
    }
}

