/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Daily;
import org.sonatype.nexus.scheduling.schedule.Hourly;
import org.sonatype.nexus.scheduling.schedule.Monthly;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.Weekly;

public class ScheduleSerializer
extends StdSerializer<Schedule> {
    private static final long serialVersionUID = 6929523949071161349L;

    public ScheduleSerializer() {
        super(Schedule.class);
    }

    public void serialize(Schedule value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("type", value.getType());
        if (value instanceof Monthly) {
            Monthly monthly = (Monthly)value;
            jgen.writeObjectField("startAt", (Object)monthly.getStartAt());
            jgen.writeObjectField("daysToRun", monthly.getDaysToRun());
        } else if (value instanceof Weekly) {
            Weekly daily = (Weekly)value;
            jgen.writeObjectField("startAt", (Object)daily.getStartAt());
            jgen.writeObjectField("daysToRun", daily.getDaysToRun());
        } else if (value instanceof Daily) {
            Daily daily = (Daily)value;
            jgen.writeObjectField("startAt", (Object)daily.getStartAt());
        } else if (value instanceof Hourly) {
            Hourly hourly = (Hourly)value;
            jgen.writeObjectField("startAt", (Object)hourly.getStartAt());
        } else if (value instanceof Once) {
            Once once = (Once)value;
            jgen.writeObjectField("startAt", (Object)once.getStartAt());
        } else if (value instanceof Cron) {
            Cron cron = (Cron)value;
            jgen.writeObjectField("startAt", (Object)cron.getStartAt());
            jgen.writeObjectField("cronExpression", (Object)cron.getCronExpression());
            jgen.writeObjectField("timeZone", (Object)cron.getTimeZone());
        }
        jgen.writeEndObject();
    }
}

