/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Set;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Daily;
import org.sonatype.nexus.scheduling.schedule.Hourly;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Monthly;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.scheduling.schedule.Weekly;

public class ScheduleFactoryImpl
extends ComponentSupport
implements ScheduleFactory {
    @Override
    public Manual manual() {
        return new Manual();
    }

    @Override
    public Now now() {
        return new Now();
    }

    @Override
    public Once once(Date startAt) {
        Preconditions.checkNotNull((Object)startAt);
        return new Once(startAt);
    }

    @Override
    public Hourly hourly(Date startAt) {
        Preconditions.checkNotNull((Object)startAt);
        return new Hourly(startAt);
    }

    @Override
    public Daily daily(Date startAt) {
        Preconditions.checkNotNull((Object)startAt);
        return new Daily(startAt);
    }

    @Override
    public Weekly weekly(Date startAt, Set<Weekly.Weekday> daysToRun) {
        Preconditions.checkNotNull((Object)startAt);
        Preconditions.checkNotNull(daysToRun);
        Preconditions.checkArgument((!daysToRun.isEmpty() ? 1 : 0) != 0, (Object)"No days of week set to run");
        return new Weekly(startAt, daysToRun);
    }

    @Override
    public Monthly monthly(Date startAt, Set<Monthly.CalendarDay> daysToRun) {
        Preconditions.checkNotNull((Object)startAt);
        Preconditions.checkNotNull(daysToRun);
        Preconditions.checkArgument((!daysToRun.isEmpty() ? 1 : 0) != 0, (Object)"No days of month set to run");
        return new Monthly(startAt, daysToRun);
    }

    @Override
    public Cron cron(Date startAt, String cronExpression) {
        Preconditions.checkNotNull((Object)startAt);
        Preconditions.checkNotNull((Object)cronExpression);
        return new Cron(startAt, cronExpression);
    }

    @Override
    public Cron cron(Date startAt, String cronExpression, String zoneId) {
        Preconditions.checkNotNull((Object)startAt);
        Preconditions.checkNotNull((Object)cronExpression);
        Preconditions.checkNotNull((Object)zoneId);
        return new Cron(startAt, cronExpression, zoneId);
    }
}

