/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class Monthly
extends Schedule {
    public static final String TYPE = "monthly";

    public Monthly(Date startAt, Set<CalendarDay> daysToRun) {
        super(TYPE);
        this.set("schedule.startAt", Monthly.dateToString(startAt));
        this.set("schedule.daysToRun", Monthly.setToCsv(daysToRun, CalendarDay.dayToString));
    }

    public Date getStartAt() {
        return Monthly.stringToDate(this.get("schedule.startAt"));
    }

    public Set<CalendarDay> getDaysToRun() {
        return Monthly.csvToSet(this.get("schedule.daysToRun"), CalendarDay.stringToDay);
    }

    public static final class CalendarDay
    implements Comparable<CalendarDay> {
        private static final int LAST_DAY_OF_MONTH = 999;
        private static final CalendarDay LAST_DAY = new CalendarDay(999);
        private final int day;
        public static final Function<CalendarDay, String> dayToString = input -> Integer.toString(input.getDay());
        public static final Function<String, CalendarDay> stringToDay = input -> new CalendarDay(Integer.parseInt(input));

        public static CalendarDay day(int day) {
            return new CalendarDay(day);
        }

        public static Set<CalendarDay> days(int ... days) {
            HashSet<CalendarDay> result = new HashSet<CalendarDay>();
            int[] nArray = days;
            int n = days.length;
            int n2 = 0;
            while (n2 < n) {
                int day = nArray[n2];
                result.add(CalendarDay.day(day));
                ++n2;
            }
            return result;
        }

        public static CalendarDay lastDay() {
            return LAST_DAY;
        }

        private CalendarDay(int day) {
            Preconditions.checkArgument((day >= 1 && day <= 31 || day == 999 ? 1 : 0) != 0, (String)"Invalid calendar day %s", (int)day);
            this.day = day;
        }

        public int getDay() {
            return this.day;
        }

        public boolean isLastDayOfMonth() {
            return this.day == 999;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "day=" + (this.day == 999 ? "last" : Integer.valueOf(this.day)) + '}';
        }

        @Override
        public int compareTo(CalendarDay other) {
            return this.day - other.day;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CalendarDay that = (CalendarDay)o;
            return this.day == that.day;
        }

        public int hashCode() {
            return this.day;
        }
    }
}

