/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import java.util.Date;
import java.util.TimeZone;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class Cron
extends Schedule {
    public static final String TYPE = "cron";
    public static final String SCHEDULE_CRON_EXPRESSION = "schedule.cronExpression";

    public Cron(Date startAt, String cronExpression) {
        this(startAt, cronExpression, TimeZone.getDefault().getID());
    }

    public Cron(Date startAt, String cronExpression, String zoneId) {
        super(TYPE);
        this.set("schedule.startAt", Cron.dateToString(startAt));
        this.set(SCHEDULE_CRON_EXPRESSION, cronExpression);
        this.set("schedule.clientTimeZone", zoneId);
    }

    public Date getStartAt() {
        return Cron.stringToDate(this.get("schedule.startAt"));
    }

    public String getCronExpression() {
        return this.get(SCHEDULE_CRON_EXPRESSION);
    }

    public TimeZone getTimeZone() {
        return Cron.stringToTimeZone(this.get("schedule.clientTimeZone"));
    }
}

