/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal.upgrade.orient;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class PostStartupTaskSchedulerImpl
extends StateGuardLifecycleSupport
implements UpgradeTaskScheduler {
    private final List<TaskConfiguration> configurations = new ArrayList<TaskConfiguration>();
    private final TaskScheduler scheduler;

    @Inject
    public PostStartupTaskSchedulerImpl(TaskScheduler scheduler) {
        this.scheduler = (TaskScheduler)Preconditions.checkNotNull((Object)scheduler);
    }

    @Override
    public void schedule(TaskConfiguration configuration) {
        if (this.isStarted()) {
            this.scheduleTask(configuration);
        } else {
            this.configurations.add(configuration);
        }
    }

    @Override
    public TaskConfiguration createTaskConfigurationInstance(String typeId) {
        return this.scheduler.createTaskConfigurationInstance(typeId);
    }

    protected void doStart() throws Exception {
        this.configurations.forEach(this::scheduleTask);
        this.configurations.clear();
    }

    private void scheduleTask(TaskConfiguration configuration) {
        try {
            TaskInfo taskInfo = this.scheduler.submit(configuration);
            this.log.debug("Scheduled {} for {}", (Object)taskInfo, (Object)configuration);
        }
        catch (Exception e) {
            this.log.warn("An error occurred scheduling a required task", (Throwable)e);
        }
    }
}

