/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal.upgrade.datastore;

import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.scheduling.internal.upgrade.datastore.UpgradeTaskDAO;
import org.sonatype.nexus.scheduling.internal.upgrade.datastore.UpgradeTaskData;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class UpgradeTaskStore
extends ConfigStoreSupport<UpgradeTaskDAO> {
    @Inject
    public UpgradeTaskStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier, UpgradeTaskDAO.class);
    }

    @Transactional
    public void insert(UpgradeTaskData task) {
        ((UpgradeTaskDAO)this.dao()).create(task);
    }

    @Transactional
    public Optional<UpgradeTaskData> read(int id) {
        return ((UpgradeTaskDAO)this.dao()).read(id);
    }

    @Transactional
    public int markFailed(String id) {
        return ((UpgradeTaskDAO)this.dao()).setStatus(id, "failed");
    }

    @Transactional
    public int markCanceled(String taskId) {
        return ((UpgradeTaskDAO)this.dao()).setStatus(taskId, "canceled");
    }

    @Transactional
    public int deleteByTaskId(String id) {
        return ((UpgradeTaskDAO)this.dao()).deleteByTaskId(id);
    }

    @Transactional
    public Stream<UpgradeTaskData> browse() {
        return StreamSupport.stream(((UpgradeTaskDAO)this.dao()).browse().spliterator(), false);
    }

    @Transactional
    public void update(UpgradeTaskData task) {
        ((UpgradeTaskDAO)this.dao()).update(task);
    }

    @Transactional
    public Optional<UpgradeTaskData> next() {
        return ((UpgradeTaskDAO)this.dao()).next();
    }
}

